package common.web.tools.webapi.processor;


import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import common.base.tools.exception.ApiException;
import common.base.tools.type.CollectionUtils;
import common.base.tools.type.StringTools;
import common.config.tools.config.ConfigTools3;
import common.web.tools.http.HttpTools;
import common.web.tools.webapi.annotation.WebApiAuthorizedIP;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;

/**
 * Created by Frank.Huang on 2017/1/19.
 */
@Aspect
@Service
public class WebApiAuthorizedIPInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiAuthorizedIPInterceptor.class);


    @Pointcut(value = "@annotation(common.web.tools.webapi.annotation.WebApiAuthorizedIP)")
    public void webApiCallIpCheck() {
    }


    @Before(value = "common.web.tools.webapi.processor.WebApiAuthorizedIPInterceptor.webApiCallIpCheck()&&@annotation(wacic)")
    public void authIpCheck(JoinPoint jp, WebApiAuthorizedIP wacic) throws ApiException {
        Set<String> authIps = Sets.newHashSet();

        String ips = wacic.authIps();
        String ipCfgName = wacic.authIpCfgName();
        if (!Strings.isNullOrEmpty(ips)) {
            authIps.addAll(StringTools.parseAsList(ips,","));
        }

        if (!Strings.isNullOrEmpty(ipCfgName)) {
            List<String> authIpList = ConfigTools3.getAsList(ipCfgName);
            if (!CollectionUtils.isNullOrEmpty(authIpList)) {
                authIps.addAll(authIpList);
            }
        }

        if (CollectionUtils.isNullOrEmpty(authIps)) {
            return;
        }

        HttpServletRequest request = (HttpServletRequest) jp.getArgs()[0];
        String clientIp = HttpTools.getRemoteHost(request);
        if (!authIps.contains(clientIp)) {
            String msg = String.format("IP[%s] is not authorized", clientIp);
            logger.warn(msg);
            throw new ApiException(-999, 1, msg);
        }
    }
}
