package common.web.tools.filter.crypt;


import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 *
 */
public class AESIVTools {
	/**
	 * AES
	 */
	public static byte[] encrypt(byte[] input, byte[] key, byte[] iv) {
		byte[] crypted = null;
		try {
			IvParameterSpec ivSpec = new IvParameterSpec(iv);
			SecretKeySpec skey = new SecretKeySpec(key, "AES");
			Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
			cipher.init(Cipher.ENCRYPT_MODE, skey, ivSpec);
			crypted = cipher.doFinal(input);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return crypted;
	}
	public static String encryptToBase64(String input, byte[] key, byte[] iv) {
		byte[] crypted = encrypt(input.getBytes(), key, iv);
		return Base64.encodeBase64String(crypted);
	}
	
	public static String encryptToBase64(byte[] input, byte[] key, byte[] iv) {
		byte[] crypted = encrypt(input, key, iv);
		return Base64.encodeBase64String(crypted);
	}
	
	/**
	 * AES
	 */
	public static byte[] decrypt(byte[] input, byte[] key, byte[] iv) {
		try {
			byte[] output = null;
			IvParameterSpec ivSpec = new IvParameterSpec(iv);
			SecretKeySpec skey = new SecretKeySpec(key, "AES");
			Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
			cipher.init(Cipher.DECRYPT_MODE, skey, ivSpec);
			output = cipher.doFinal(input);
			return output;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}

	}

	public static String decryptToString(String input, byte[] key, byte[] iv) {
		byte[] bytes = decrypt(input.getBytes(), key, iv);
		if (bytes != null) {
			return new String(bytes);
		}
		return null;
	}

	public static String encrypt(String input, String key, String iv) {
		byte[] keyBytes = Base64.decodeBase64(key);
		byte[] crypted = encrypt(input.getBytes(), keyBytes, iv.getBytes());
		return Base64.encodeBase64URLSafeString(crypted);
	}

	public static String decrypt(String input, String key, String iv) {
		byte[] inputBytes = Base64.decodeBase64(input);
		byte[] keyBytes = Base64.decodeBase64(key);
		
		byte[] bytes = decrypt(inputBytes, keyBytes, iv.getBytes());
		if (bytes != null) {
			return new String(bytes);
		}
		return null;
	}

}