package common.web.tools.filter.crypt.filter;


import com.google.common.base.Strings;
import com.google.gson.Gson;
import common.base.tools.sys.SystemTools;
import common.web.tools.filter.crypt.CryptACL;
import common.web.tools.filter.crypt.CryptMsgTools;
import common.web.tools.filter.crypt.model.ApiCryptMsg;
import common.web.tools.filter.crypt.model.ApiCryptMsg4Live;
import common.web.tools.http.HttpTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;


public class ResponseCryptFilter extends OncePerRequestFilter {

    private static final Logger logger = LoggerFactory.getLogger(ResponseCryptFilter.class);
    private Gson gson = new Gson();

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
        throws ServletException, IOException {
        RequestCryptWrapper reqWrapper = new RequestCryptWrapper(request);
        String v = reqWrapper.getParameter("v");
        if (Strings.isNullOrEmpty(v)) {
            v = reqWrapper.getParameter("prot");
        }

        String url = HttpTools.getRequestURI(request);

        if (Strings.isNullOrEmpty(v) || CryptACL.isResponseOri(url)) {
            filterChain.doFilter(request, response);
        } else {
            try (OutputStream out = response.getOutputStream()) {
                ResponseCryptWrapper wrapper = new ResponseCryptWrapper(response);
                filterChain.doFilter(request, wrapper);

                if (CryptACL.isContentTypeCrype(wrapper.getContentType()))
                    out.write(wrapper.getData());
                else {
                    String cryptMsg = "";
                    if (CryptMsgTools.isLiveMsg(v)) {
                        cryptMsg = getCryptMessage4Live(url, v, wrapper.getData());
                    } else {
                        cryptMsg = getCryptMessage(url, v, wrapper.getData());
                    }

                    out.write(cryptMsg.getBytes("utf-8"));
                }
            } finally {
            }
        }

    }

    @Override
    public void destroy() {
        // empty interface implementation
    }

    private String getCryptMessage(String url, String protocol, byte[] data) throws IOException {
        boolean cryptEnable = CryptACL.isCryptEnable(url);
        try {
            ApiCryptMsg msg = new ApiCryptMsg();
            msg.setH(SystemTools.getHostnameMD5());
            msg.setT(System.currentTimeMillis());

            if (cryptEnable && CryptMsgTools.isSupportCrypt(protocol)) {
                msg.setV(protocol);
                msg.setM(CryptMsgTools.encryptMsg(protocol, data));
            } else {
                msg.setV("0");
                msg.setM(new String(data, "UTF-8"));
            }
            msg.setS(CryptMsgTools.sign(protocol, msg.getM()));

            return gson.toJson(msg);

        } finally {

        }
    }

    private String getCryptMessage4Live(String url, String prot, byte[] data) throws IOException {
        boolean cryptEnable = CryptACL.isCryptEnable(url);
        try {
            ApiCryptMsg4Live msg = new ApiCryptMsg4Live();

            if (cryptEnable && CryptMsgTools.isSupportCrypt(prot)) {
                msg.setProt(prot);
                msg.setPayload(CryptMsgTools.encryptMsg(prot, data));
            } else {
                msg.setProt("0");
                msg.setPayload(new String(data, "UTF-8"));
            }
            msg.setSignature(CryptMsgTools.sign(prot, msg.getPayload()));

            return gson.toJson(msg);

        } finally {

        }
    }


}
