/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.crypt;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import common.base.tools.compress.GZipTools;
import common.base.tools.encrypt.AESUtils;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import common.web.tools.filter.crypt.AESIVTools;
import common.web.tools.filter.crypt.JaqSecurity;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptMsgTools {
    private static final Logger logger = LoggerFactory.getLogger(CryptMsgTools.class);
    public static String CRYPT_AES_CONFIG_KEY = "crypt.aes.key";
    public static String CRYPT_JAQ_CONFIG_KEY = "crypt.jaq.key";
    public static String CRYPT_JAQ_CONFIG_KEY_V2 = "crypt.jaq.v2.key";
    public static String CRYPT_JAQ_CONFIG_KEY_V2_AES_KEY = "crypt.jaq.v2.key.aes.key";
    public static String CRYPT_JAQ_CONFIG_KEY_V2_AES_IV = "crypt.jaq.v2.key.aes.iv";
    private static Map<String, String> cryptKeyMap = Maps.newHashMap();

    public static void setCryptKey(String key, String value) {
        cryptKeyMap.put(key, value);
    }

    public static String getCryptKey(String key) {
        String cryptKey = ConfigTools3.getString((String)key, (String)cryptKeyMap.getOrDefault(key, ""));
        if (Strings.isNullOrEmpty((String)cryptKey)) {
            throw new RuntimeException(String.format("Crypt key[%s] not configuration!", key));
        }
        return cryptKey;
    }

    public static String getCryptJaqKey() {
        return CryptMsgTools.getCryptKey(CRYPT_JAQ_CONFIG_KEY);
    }

    public static String getCryptJaqV2Key() {
        return CryptMsgTools.getCryptKey(CRYPT_JAQ_CONFIG_KEY_V2);
    }

    public static String getCryptAesKey() {
        return CryptMsgTools.getCryptKey(CRYPT_AES_CONFIG_KEY);
    }

    public static String decryptMsg(String protocol, String msg, String signature) throws Exception {
        return CryptMsgTools.decryptMsg(protocol, msg, signature, false);
    }

    public static String decryptMsg(String protocol, String msg, String signature, boolean isSupport) throws Exception {
        if (Strings.isNullOrEmpty((String)msg)) {
            logger.error("Encrypt msg is empty");
            return "";
        }
        String ungzip = msg;
        if (isSupport && CryptMsgTools.isSupportGzip(protocol)) {
            ungzip = GZipTools.decompress((String)msg);
        }
        try {
            if (CryptMsgTools.isCryptAES(protocol)) {
                return AESUtils.decrypt((String)ungzip, (String)CryptMsgTools.getCryptAesKey());
            }
            if (CryptMsgTools.isCryptJAQ(protocol)) {
                boolean checked;
                String aesMsg = "";
                if (CryptMsgTools.isCryptJAQV2(protocol) && Strings.isNullOrEmpty((String)(msg = AESIVTools.decrypt(aesMsg = ungzip, CryptMsgTools.getCryptKey(CRYPT_JAQ_CONFIG_KEY_V2_AES_KEY), CryptMsgTools.getCryptKey(CRYPT_JAQ_CONFIG_KEY_V2_AES_IV))))) {
                    return "";
                }
                String jaqKey = "";
                jaqKey = CryptMsgTools.isCryptJAQV2(protocol) ? CryptMsgTools.getCryptJaqV2Key() : CryptMsgTools.getCryptJaqKey();
                if (!CryptMsgTools.isLiveMsg(protocol) && !(checked = JaqSecurity.checkSign(msg, jaqKey, signature))) {
                    throw new ApiException(-999, 1, "Message sign check failed.");
                }
                byte[] decodeBytes = JaqSecurity.decrypt(msg.getBytes(), jaqKey);
                if (decodeBytes == null) {
                    return "";
                }
                String payload = new String(decodeBytes);
                if (CryptMsgTools.isLiveMsg(protocol)) {
                    boolean checked2 = true;
                    checked2 = CryptMsgTools.isCryptJAQV2(protocol) ? JaqSecurity.checkSign(aesMsg, jaqKey, signature) : JaqSecurity.checkSign(payload, jaqKey, signature);
                    if (!checked2) {
                        throw new ApiException(-999, 1, "Message sign check failed.");
                    }
                }
                return payload;
            }
            throw new ApiException(-999, 2, "Message decrypt exception.");
        }
        catch (Exception e) {
            logger.error("Decode arg exception:{}", (Throwable)e);
            if (e instanceof ApiException) {
                throw e;
            }
            throw new ApiException(-999, 3, "Message decrypt exception.");
        }
    }

    public static String encryptMsg(String protocol, String msg) {
        if (Strings.isNullOrEmpty((String)msg)) {
            logger.error("Encrypt msg is empty");
            return "";
        }
        String gzipMsg = msg;
        if (CryptMsgTools.isSupportGzip(protocol)) {
            gzipMsg = GZipTools.compress((String)msg);
        }
        try {
            if (CryptMsgTools.isCryptAES(protocol)) {
                return AESUtils.encrypt((String)gzipMsg, (String)CryptMsgTools.getCryptAesKey());
            }
            if (CryptMsgTools.isCryptJAQ(protocol)) {
                if (CryptMsgTools.isCryptJAQV2(protocol)) {
                    if (Strings.isNullOrEmpty((String)gzipMsg)) {
                        return "";
                    }
                    String jaqMsg = JaqSecurity.encrypt(gzipMsg, CryptMsgTools.getCryptJaqV2Key());
                    if (Strings.isNullOrEmpty((String)jaqMsg)) {
                        return "";
                    }
                    return AESIVTools.encrypt(jaqMsg, CryptMsgTools.getCryptKey(CRYPT_JAQ_CONFIG_KEY_V2_AES_KEY), CryptMsgTools.getCryptKey(CRYPT_JAQ_CONFIG_KEY_V2_AES_IV));
                }
                return JaqSecurity.encrypt(gzipMsg, CryptMsgTools.getCryptJaqKey());
            }
            return "";
        }
        catch (Exception e) {
            logger.error("Encrypt Message exception:{}", (Throwable)e);
            return "";
        }
    }

    public static String encryptMsg(String protocol, byte[] msg) {
        return CryptMsgTools.encryptMsg(protocol, new String(msg));
    }

    public static String sign(String protocol, String msg) {
        try {
            if (CryptMsgTools.isCryptJAQ(protocol)) {
                if (CryptMsgTools.isCryptJAQV2(protocol)) {
                    return JaqSecurity.sign(msg, CryptMsgTools.getCryptJaqV2Key());
                }
                return JaqSecurity.sign(msg, CryptMsgTools.getCryptJaqKey());
            }
            return "";
        }
        catch (Exception e) {
            logger.error("Sign message exception:{}", (Throwable)e);
            return "";
        }
    }

    public static boolean isCryptJAQ(String v) {
        if ("4".contentEquals(v)) {
            return true;
        }
        if ("ACM11".contentEquals(v)) {
            return true;
        }
        if ("ACM20".contentEquals(v)) {
            return true;
        }
        return "ACM21".contentEquals(v);
    }

    public static boolean isCryptJAQV2(String v) {
        if ("ACM20".contentEquals(v)) {
            return true;
        }
        return "ACM21".contentEquals(v);
    }

    public static boolean isCryptAES(String v) {
        if ("3".contentEquals(v)) {
            return true;
        }
        return "ACM1".contentEquals(v);
    }

    public static boolean isLiveMsg(String v) {
        return !"3".contentEquals(v) && !"4".contentEquals(v);
    }

    public static boolean isSupportCrypt(String v) {
        return "3".contentEquals(v) || "4".contentEquals(v) || "ACM1".contentEquals(v) || "ACM11".contentEquals(v) || "ACM20".contentEquals(v) || "ACM21".contentEquals(v);
    }

    public static boolean isSupportGzip(String v) {
        return "ACM21".contentEquals(v);
    }

    public static boolean isSupportProtocol(String v) {
        List protocols = ConfigTools3.getAsList((String)"crypt.support.protocol");
        if (protocols.isEmpty()) {
            return true;
        }
        return protocols.contains(v);
    }
}

