/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.errormsg;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import common.base.tools.encrypt.Base62Tools;
import common.config.tools.config.ConfigTools3;
import common.web.tools.errormsg.ErrorLangTools;

public class ErrorMsgBuilder {
    public static String getSeparatorChar() {
        return ".";
    }

    public static String encodeUserAlias(String userAlias) {
        return Base62Tools.longToBase62((String)userAlias);
    }

    public static String getErrorCode(int ret, int err) {
        return Joiner.on((String)ErrorMsgBuilder.getSeparatorChar()).join((Object)ret, (Object)err, new Object[0]);
    }

    public static String getErrMsgKey(String lang, int ret, int err) {
        String language = ErrorLangTools.getOrDefaultLanguage(Strings.nullToEmpty((String)lang).toLowerCase());
        return Joiner.on((String)".").join((Object)language, (Object)ret, new Object[]{err});
    }

    public static String getErrMsgDesc(String lang, int ret, int err, String defaultMsg) {
        String msg = ConfigTools3.getString((String)ErrorMsgBuilder.getErrMsgKey(lang, ret, err), (String)defaultMsg);
        if (Strings.isNullOrEmpty((String)msg) && !ErrorLangTools.isEnglish(lang)) {
            msg = ConfigTools3.getString((String)ErrorMsgBuilder.getErrMsgKey(ErrorLangTools.LANG_EN, ret, err), (String)defaultMsg);
        }
        return msg;
    }

    public static String fmtErrMsg(String userAlias, int ret, int err, String msg, String reason) {
        String errTS = Base62Tools.longToBase62((long)(System.currentTimeMillis() / 1000L));
        String errId = Joiner.on((String)ErrorMsgBuilder.getSeparatorChar()).join((Object)ErrorMsgBuilder.encodeUserAlias(userAlias), (Object)errTS, new Object[]{ErrorMsgBuilder.getErrorCode(ret, err)});
        String errMsg = "NA";
        if (!Strings.isNullOrEmpty((String)msg)) {
            errMsg = msg;
        }
        if (Strings.isNullOrEmpty((String)reason)) {
            errMsg = errMsg + "(" + reason + ")";
        }
        return errId + ":" + errMsg;
    }

    public static String getErrorMsg(String userAlias, String lang, int ret, int err, String defaultMsg, String reason) {
        String msg = ErrorMsgBuilder.getErrMsgDesc(lang, ret, err, defaultMsg);
        return ErrorMsgBuilder.fmtErrMsg(userAlias, ret, err, msg, reason);
    }

    public static String getErrorMsg(String userAlias, String lang, int ret, int err, String defaultMsg) {
        return ErrorMsgBuilder.getErrorMsg(userAlias, lang, ret, err, defaultMsg, "");
    }

    public static String getErrorMsg(String userAlias, String lang, int ret, int err) {
        return ErrorMsgBuilder.getErrorMsg(userAlias, lang, ret, err, "", "");
    }

    public static String getErrorMsg(long userAlias, String lang, int ret, int err, String defaultMsg, String reason) {
        String msg = ErrorMsgBuilder.getErrMsgDesc(lang, ret, err, defaultMsg);
        return ErrorMsgBuilder.fmtErrMsg(Long.valueOf(userAlias).toString(), ret, err, msg, reason);
    }

    public static String getErrorMsg(long userAlias, String lang, int ret, int err, String defaultMsg) {
        return ErrorMsgBuilder.getErrorMsg(userAlias, lang, ret, err, defaultMsg, "");
    }

    public static String getErrorMsg(long userAlias, String lang, int ret, int err) {
        return ErrorMsgBuilder.getErrorMsg(userAlias, lang, ret, err, "", "");
    }
}

