/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.crypt;

import common.config.tools.config.ConfigTools3;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESIVTools {
    public static byte[] encrypt(byte[] input, byte[] key, byte[] iv) {
        byte[] crypted = null;
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)skey, ivSpec);
            crypted = cipher.doFinal(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crypted;
    }

    public static String encryptToBase64(String input, byte[] key, byte[] iv) {
        byte[] crypted = AESIVTools.encrypt(input.getBytes(), key, iv);
        return Base64.encodeBase64String((byte[])crypted);
    }

    public static String encryptToBase64(byte[] input, byte[] key, byte[] iv) {
        byte[] crypted = AESIVTools.encrypt(input, key, iv);
        return Base64.encodeBase64String((byte[])crypted);
    }

    public static byte[] decrypt(byte[] input, byte[] key, byte[] iv) {
        try {
            byte[] output = null;
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)skey, ivSpec);
            output = cipher.doFinal(input);
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptToString(String input, byte[] key, byte[] iv) {
        byte[] bytes = AESIVTools.decrypt(input.getBytes(), key, iv);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static String encrypt(String input, String key, String iv) {
        byte[] keyBytes = Base64.decodeBase64((String)key);
        byte[] crypted = AESIVTools.encrypt(input.getBytes(), keyBytes, iv.getBytes());
        return Base64.encodeBase64URLSafeString((byte[])crypted);
    }

    public static String decrypt(String input, String key, String iv) {
        byte[] keyBytes;
        byte[] inputBytes = Base64.decodeBase64((String)input);
        byte[] bytes = AESIVTools.decrypt(inputBytes, keyBytes = Base64.decodeBase64((String)key), iv.getBytes());
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public static String getAesKey(String protocol) {
        String key = String.format("crypt.aes.key.%s", protocol).toLowerCase();
        return ConfigTools3.getNonEmptyString((String)key);
    }

    public static String getAesIV(String protocol) {
        String key = String.format("crypt.aes.iv.%s", protocol).toLowerCase();
        return ConfigTools3.getNonEmptyString((String)key);
    }

    public static String encrypt(String protocol, String input) {
        return AESIVTools.encrypt(input, AESIVTools.getAesKey(protocol), AESIVTools.getAesIV(protocol));
    }

    public static String decrypt(String protocol, String input) {
        return AESIVTools.decrypt(input, AESIVTools.getAesKey(protocol), AESIVTools.getAesIV(protocol));
    }
}

