package common.web.tools.errormsg;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import common.base.tools.encrypt.Base62Tools;
import common.config.tools.config.ConfigTools3;

public class ErrorMsgBuilder {

    public static String getSeparatorChar() {
        return ".";
    }

    public static String encodeUserAlias(String userAlias) {
        return Base62Tools.longToBase62(userAlias);
    }

    public static String getErrorCode(int ret, int err) {
        return Joiner.on(getSeparatorChar()).join(ret, err);
    }

    public static String getErrMsgKey(String lang, int ret, int err) {
        String language = ErrorLangTools.getOrDefaultLanguage(Strings.nullToEmpty(lang).toLowerCase());
        return Joiner.on(".").join(language, ret, err);
    }


    public static String getErrMsgDesc(String lang, int ret, int err, String defaultMsg) {
        String msg = ConfigTools3.getString(getErrMsgKey(lang, ret, err), defaultMsg);
        if (Strings.isNullOrEmpty(msg) && !ErrorLangTools.isEnglish(lang)) {
            msg = ConfigTools3.getString(getErrMsgKey(ErrorLangTools.LANG_EN, ret, err), defaultMsg);
        }

        return msg;
    }

    public static String fmtErrMsg(String userAlias, int ret, int err, String msg, String reason) {
        String errTS = Base62Tools.longToBase62(System.currentTimeMillis() / 1000);
        String errId = Joiner.on(getSeparatorChar()).join(encodeUserAlias(userAlias), errTS, getErrorCode(ret, err));
        String errMsg = "NA";
        if (!Strings.isNullOrEmpty(msg)) {
            errMsg = msg;
        }

        if (Strings.isNullOrEmpty(reason)) {
            errMsg += "(" + reason + ")";
        }

        return errId + ":" + errMsg;
    }

    public static String getErrorMsg(String userAlias, String lang, int ret, int err, String defaultMsg, String reason) {
        String msg = getErrMsgDesc(lang, ret, err, defaultMsg);
        return fmtErrMsg(userAlias, ret, err, msg, reason);
    }


    public static String getErrorMsg(String userAlias, String lang, int ret, int err, String defaultMsg) {
        return getErrorMsg(userAlias, lang, ret, err, defaultMsg, "");
    }

    public static String getErrorMsg(String userAlias, String lang, int ret, int err) {
        return getErrorMsg(userAlias, lang, ret, err, "", "");
    }

    public static String getErrorMsg(long userAlias, String lang, int ret, int err, String defaultMsg, String reason) {
        String msg = getErrMsgDesc(lang, ret, err, defaultMsg);
        return fmtErrMsg(Long.valueOf(userAlias).toString(), ret, err, msg, reason);
    }

    public static String getErrorMsg(long userAlias, String lang, int ret, int err, String defaultMsg) {
        return getErrorMsg(userAlias, lang, ret, err, defaultMsg, "");
    }


    public static String getErrorMsg(long userAlias, String lang, int ret, int err) {
        return getErrorMsg(userAlias, lang, ret, err, "", "");
    }

}
