package common.web.tools.exception.handler;


import common.base.tools.exception.ApiException;
import common.web.tools.http.model.response.WebApiBaseResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * Created by Frank.Huang on 2017/1/17.
 */
@ControllerAdvice
public class ApiExceptionHandler {

    @ResponseBody
    @ExceptionHandler(value = ApiException.class)
    public WebApiBaseResponse apiException(HttpServletRequest httpRequest,
                                           HttpServletResponse httpResponse,
                                           ApiException apiException){


        httpResponse.setStatus(555);
        WebApiBaseResponse response = new WebApiBaseResponse();
        response.setRetCode(apiException.getRetCode());
        response.setErrCode(apiException.getErrCode());
        response.setMessage(apiException.getMessage());
        
        return response;
    }

}
