/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.diagnosis;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import common.base.tools.sys.SystemTools;
import common.web.tools.diagnosis.ManifestTools;
import common.web.tools.http.HttpTools;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DiagnosisController {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisController.class);

    @ResponseBody
    @RequestMapping(value={"/api/ping2"})
    public Map<String, String> ping(HttpServletRequest httpRequest, HttpServletResponse httpResponse, @RequestParam(required=false, defaultValue="0") int debug) {
        String clientIp = HttpTools.getRemoteHost(httpRequest);
        LinkedHashMap response = Maps.newLinkedHashMap();
        response.put("server", SystemTools.getHostnameMD5());
        Date dateNow = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        response.put("serverTimestamp", dateNow.getTime() + "");
        response.put("serverTime", simpleDateFormat.format(dateNow));
        response.put("clientIp", clientIp);
        if (debug == 1) {
            String springbootVersion;
            String buildJdk;
            String buildTime;
            String buildBy;
            String builtVersion = ManifestTools.getInstance().getManifest("Built-Version");
            if (!Strings.isNullOrEmpty((String)builtVersion)) {
                response.put("Built-Version", builtVersion);
            }
            if (!Strings.isNullOrEmpty((String)(buildBy = ManifestTools.getInstance().getManifest("Built-By")))) {
                response.put("Built-By", buildBy);
            }
            if (!Strings.isNullOrEmpty((String)(buildTime = ManifestTools.getInstance().getManifest("Built-Time")))) {
                response.put("Built-Time", buildTime);
            }
            if (!Strings.isNullOrEmpty((String)(buildJdk = ManifestTools.getInstance().getManifest("Built-Jdk")))) {
                response.put("Built-Jdk", buildJdk);
            }
            if (!Strings.isNullOrEmpty((String)(springbootVersion = ManifestTools.getInstance().getManifest("Spring-Boot-Version")))) {
                response.put("Built-Spring-Boot-Version", springbootVersion);
            }
        }
        return response;
    }
}

