/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.crypt.filter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import common.base.tools.JSON.JSONTools;
import common.base.tools.type.CollectionUtils;
import common.web.tools.filter.crypt.CryptMsgTools;
import common.web.tools.filter.crypt.filter.RequestCryptWrapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestCryptFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestCryptFilter.class);
    private Gson gson = new Gson();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String s;
        String m;
        RequestCryptWrapper wrapper = new RequestCryptWrapper(request);
        String v = wrapper.getParameter("v");
        if (Strings.isNullOrEmpty((String)v)) {
            v = wrapper.getParameter("prot");
        }
        if (Strings.isNullOrEmpty((String)(m = wrapper.getParameter("m")))) {
            m = wrapper.getParameter("payload");
        }
        if (Strings.isNullOrEmpty((String)(s = wrapper.getParameter("s")))) {
            s = wrapper.getParameter("signature");
        }
        if (!Strings.isNullOrEmpty((String)v) && !Strings.isNullOrEmpty((String)m)) {
            try {
                String dm = CryptMsgTools.decryptMsg(v, m, s);
                Map decryptMap = (Map)JSONTools.fromJson2((String)dm, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (!CollectionUtils.isNullOrEmpty((Map)decryptMap)) {
                    wrapper.addAllParameters(decryptMap);
                }
            }
            catch (Exception e) {
                logger.error("Exception:{}", (Throwable)e);
                throw new IllegalArgumentException(e.toString());
            }
        }
        filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
    }

    public void destroy() {
    }
}

