package common.web.tools.filter.crypt.filter;


import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import common.base.tools.JSON.JSONTools;
import common.base.tools.type.CollectionUtils;
import common.web.tools.filter.crypt.CryptMsgTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

public class RequestCryptFilter extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestCryptFilter.class);

    private Gson gson = new Gson();

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
        throws ServletException, IOException {
        RequestCryptWrapper wrapper = new RequestCryptWrapper(request);
        String v = wrapper.getParameter("v");
        if (Strings.isNullOrEmpty(v)) {
            v = wrapper.getParameter("prot");
        }

        String m = wrapper.getParameter("m");
        if (Strings.isNullOrEmpty(m)) {
            m = wrapper.getParameter("payload");
        }

        String s = wrapper.getParameter("s");
        if (Strings.isNullOrEmpty(s)) {
            s = wrapper.getParameter("signature");
        }

        if (!Strings.isNullOrEmpty(v) && !Strings.isNullOrEmpty(m)) {
            try {
                String dm = CryptMsgTools.decryptMsg(v, m, s);
                Map<String, Object> decryptMap = JSONTools.fromJson2(dm, new TypeReference<Map<String, Object>>() {
                });

                if (!CollectionUtils.isNullOrEmpty(decryptMap)) {
                    wrapper.addAllParameters(decryptMap);
                }
            } catch (Exception e) {
                logger.error("Exception:{}", e);
                //response.setStatus(400);
                throw new IllegalArgumentException(e.toString());
            }
        }

        filterChain.doFilter(wrapper, response);
    }

    @Override
    public void destroy() {
        // empty interface implementation
    }

}
