package common.web.tools.filter.crypt;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;


/**
 * Created by Frank.Huang on 2017/5/29.
 */
public class CryptACL {
	/*
	private static String CRYPT_KEY_ENABLE = "mfc.api.crypt";
	private static String CRYPT_RESPONSE_ORI_KEY = "mfc.api.crypt.response.ori";
	private static String CRYPT_RESPONSE_CONTENT_TYPE_KEY = "mfc.api.crypt.response.contentType";
	private static String CRYPT_CONFIG_KEY_TIME_LOG = "mfc.api.crypt.debug.time";
	*/

    private static String CRYPT_KEY_ENABLE = "crypt.response.enable";
    private static String CRYPT_KEY_DISABLE = "crypt.response.disable";
    private static String CRYPT_KEY_ENABLE_CONTENT_TYPE = "crypt.response.enable.contentType";
    private static String CRYPT_KEY_ENABLE_DEBUG = "crypt.enable.debug";

    public static boolean isContentTypeCrypt(String contentType) {
        return ConfigTools3.getAsList(CRYPT_KEY_ENABLE_CONTENT_TYPE).contains(contentType);
    }

    public static boolean isCryptEnable(String api) {
        return ConfigTools3.getBoolean(getCryptKey(api), ConfigTools3.getBoolean(CRYPT_KEY_ENABLE, false));
    }

    public static boolean isResponseCryptDisable(String api) {
        return ConfigTools3.getBoolean(getCryptResKey(api), !ConfigTools3.getBoolean(CRYPT_KEY_ENABLE, false));
    }

    public static boolean isDebugTime() {
        return ConfigTools3.getBoolean(CRYPT_KEY_ENABLE_DEBUG, false);
    }

    private static String getCryptKey(String api) {
        return String.format("%s.%s", CRYPT_KEY_ENABLE, Strings.nullToEmpty(api));
    }

    private static String getCryptResKey(String api) {
        return String.format("%s.%s", CRYPT_KEY_DISABLE, Strings.nullToEmpty(api));
    }

}
