/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.crypt.filter;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import common.base.tools.sys.SystemTools;
import common.web.tools.filter.common.WebResponseWrapper;
import common.web.tools.filter.crypt.CryptACL;
import common.web.tools.filter.crypt.CryptMsgTools;
import common.web.tools.filter.crypt.model.ApiCryptMsg;
import common.web.tools.filter.crypt.model.ApiCryptMsg4Live;
import common.web.tools.http.HttpTools;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class ResponseCryptFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCryptFilter.class);
    private Gson gson = new Gson();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String v = request.getParameter("v");
        if (Strings.isNullOrEmpty((String)v)) {
            v = request.getParameter("prot");
        }
        String url = HttpTools.getRequestURI(request);
        if (Strings.isNullOrEmpty((String)v) || CryptACL.isResponseCryptDisable(url)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            try (ServletOutputStream out = response.getOutputStream();){
                WebResponseWrapper wrapper = new WebResponseWrapper(response);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
                if (CryptACL.isContentTypeCrypt(wrapper.getContentType())) {
                    out.write(wrapper.getData());
                } else {
                    String cryptMsg = "";
                    cryptMsg = CryptMsgTools.isLiveMsg(v) ? this.getCryptMessage4Live(url, v, wrapper.getData()) : this.getCryptMessage(url, v, wrapper.getData());
                    out.write(cryptMsg.getBytes("utf-8"));
                }
            }
        }
    }

    public void destroy() {
    }

    private String getCryptMessage(String url, String protocol, byte[] data) throws IOException {
        boolean cryptEnable = CryptACL.isCryptEnable(url);
        ApiCryptMsg msg = new ApiCryptMsg();
        msg.setH(SystemTools.getHostnameMD5());
        msg.setT(System.currentTimeMillis());
        if (cryptEnable && CryptMsgTools.isSupportCrypt(protocol)) {
            msg.setV(protocol);
            msg.setM(CryptMsgTools.encryptMsg(protocol, data));
        } else {
            msg.setV("0");
            msg.setM(new String(data, "UTF-8"));
        }
        msg.setS(CryptMsgTools.sign(protocol, msg.getM()));
        return this.gson.toJson((Object)msg);
    }

    private String getCryptMessage4Live(String url, String prot, byte[] data) throws IOException {
        boolean cryptEnable = CryptACL.isCryptEnable(url);
        ApiCryptMsg4Live msg = new ApiCryptMsg4Live();
        if (cryptEnable && CryptMsgTools.isSupportCrypt(prot)) {
            msg.setProt(prot);
            msg.setPayload(CryptMsgTools.encryptMsg(prot, data));
        } else {
            msg.setProt("0");
            msg.setPayload(new String(data, "UTF-8"));
        }
        msg.setSignature(CryptMsgTools.sign(prot, msg.getPayload()));
        return this.gson.toJson((Object)msg);
    }
}

