/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.common;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import common.base.tools.type.CollectionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.http.HttpMethod;

public class WebRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private Gson gson = new Gson();

    public WebRequestWrapper(HttpServletRequest request) {
        super(request);
        if (HttpMethod.POST.name().equalsIgnoreCase(request.getMethod())) {
            this.getPostBody(request);
        }
        this.parameterMap.putAll(request.getParameterMap());
    }

    public String getParameter(String name) {
        String[] values = this.parameterMap.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    public void addAllParameters(Map<String, Object> otherParams) {
        if (!CollectionUtils.isNullOrEmpty(otherParams)) {
            for (Map.Entry<String, Object> entry : otherParams.entrySet()) {
                this.addParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.parameterMap.put(name, (String[])value);
            } else if (value instanceof String) {
                this.parameterMap.put(name, new String[]{(String)value});
            } else {
                this.parameterMap.put(name, new String[]{String.valueOf(value)});
            }
        }
    }

    private void getPostBody(HttpServletRequest request) {
        Map postMap;
        String postBody = WebRequestWrapper.getPostBodyString(request);
        if (!Strings.isNullOrEmpty((String)postBody) && !CollectionUtils.isNullOrEmpty((Map)(postMap = (Map)this.gson.fromJson(postBody, Map.class)))) {
            postMap.forEach((k, v) -> this.addParameter((String)k, v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPostBodyString(HttpServletRequest request) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder("");
        try {
            String str;
            br = request.getReader();
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

