/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.token;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import common.web.tools.http.HttpTools;
import java.io.IOException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class AbstractTokenFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTokenFilter.class);
    protected String errorUrl = "";
    protected Set<String> excludedSet = Sets.newHashSet((Object[])new String[]{"api/ping2", "api/ns"});
    protected int errCode = 0;
    private String host;
    private String uid;

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        boolean isAllowRequest = false;
        String apiPath = HttpTools.getApiPath(httpServletRequest);
        if (this.isExclude(apiPath)) {
            isAllowRequest = true;
        } else {
            this.errCode = this.verify(httpServletRequest);
            if (this.errCode == 0) {
                isAllowRequest = true;
            }
        }
        if (!isAllowRequest) {
            this.onError(httpServletRequest, httpServletResponse);
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    public int getModuleCode() {
        return 9000;
    }

    public abstract String getToken(HttpServletRequest var1);

    public abstract String getUid(HttpServletRequest var1);

    public abstract int verifyToken(HttpServletRequest var1, String var2);

    public abstract void errorHandler(HttpServletRequest var1, HttpServletResponse var2, int var3, int var4);

    public void onError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (Strings.isNullOrEmpty((String)this.errorUrl)) {
            this.errorHandler(httpServletRequest, httpServletResponse, this.getModuleCode(), this.errCode);
        } else {
            httpServletRequest.setAttribute("TOKEN_ERR_CODE", (Object)this.errCode);
            httpServletRequest.setAttribute("TOKEN_ERR_REFER", (Object)HttpTools.getApiPath(httpServletRequest));
            httpServletRequest.getServletContext().getRequestDispatcher(this.errorUrl).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    public int verify(HttpServletRequest httpRequest) {
        this.setHost(HttpTools.getRemoteHost(httpRequest));
        this.setUid(Strings.nullToEmpty((String)this.getUid(httpRequest)));
        String token = this.getToken(httpRequest);
        if (Strings.isNullOrEmpty((String)token)) {
            logger.error("[AUTH-TOKEN][{}][{}]ERR_TOKEN_IS_EMPTY", (Object)this.host, (Object)this.uid);
            return 1;
        }
        int ret = this.verifyToken(httpRequest, token);
        if (ret != 0) {
            logger.error("[AUTH-TOKEN][{}][{}]ERR_TOKEN_VERIFY_FAILED", (Object)this.uid, (Object)this.host);
        }
        return ret;
    }

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }

    public void addExcluded(String excluded) {
        if (!Strings.isNullOrEmpty((String)excluded)) {
            this.excludedSet.add(excluded);
        }
    }

    public Set<String> getExcludedSet() {
        return this.excludedSet;
    }

    public void setExcludedSet(Set<String> excludedSet) {
        this.excludedSet = excludedSet;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    private boolean isExclude(String apiPath) {
        for (String e2 : this.getExcludedSet()) {
            if (!this.isExclude(e2, apiPath)) continue;
            return true;
        }
        return false;
    }

    public boolean isExclude(String excludedPath, String apiPath) {
        int pos = excludedPath.indexOf("*");
        String excludePrefix = excludedPath;
        if (pos >= 0) {
            excludePrefix = excludedPath.substring(0, pos);
        }
        if (Strings.isNullOrEmpty((String)excludePrefix)) {
            return true;
        }
        return apiPath.startsWith(excludePrefix);
    }
}

