/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.spring;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="ApplicationContextHolder")
@Lazy(value=false)
public class ApplicationContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHolder.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return Objects.requireNonNull(applicationContext, "applicationContext is null");
    }

    public static <T> T getBean(@NonNull String name) {
        return (T)ApplicationContextHolder.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(@NonNull Class<T> clazz) {
        return (T)ApplicationContextHolder.getApplicationContext().getBean(clazz);
    }

    public static void cleanApplicationContext() {
        applicationContext = null;
    }
}

