package common.web.tools.http.restClient;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RestCallSync {
    private static Logger logger = LoggerFactory.getLogger(RestCallSync.class);
    private static RestTemplate template = null;

    private static RestTemplate getRestClient() {
        if (template == null) {
            template = new RestTemplate(RestCallClient.syncHttpFactory());
//            template.setErrorHandler(new RestErrorHandler());
        }

        return template;
    }

    /**
     * Call http post request use RestTemplate
     *
     * @param url
     * @param request
     * @param returnType
     * @param <REQ>
     * @param <RSP>
     * @return
     */
    public static <REQ, RSP> RSP postSync(String url, REQ request, Class<RSP> returnType) {
        try {
            // set headers
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<REQ> entity = new HttpEntity<>(request, headers);

            return getRestClient().postForObject(url, entity, returnType);
        } catch (RestClientException e) {
            logger.error("RestTemplate:{}", e);
            return null;
        }
    }

    public static <REQ, RSP> RSP getSync(String url, Class<RSP> returnType) {
        try {
            // set headers

            return getRestClient().getForObject(url, returnType);
        } catch (RestClientException e) {
            logger.error("RestTemplate:{}", e);
            return null;
        }
    }
}
