package common.web.tools.filter.crypt.ijiami;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.ijiami.JMEncryptBox;
import com.ijiami.JMEncryptBoxByRandom;
import com.ijiami.ResultData;
import common.base.tools.stat.StatTools;
import common.config.tools.config.ConfigTools3;
import common.web.tools.filter.crypt.CryptAESIVTools;
import common.web.tools.filter.crypt.CryptProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IJMTools {
    private static final Logger logger = LoggerFactory.getLogger(IJMTools.class);

    static {
        init();
    }

    public static int getIJMAlgorithm() {
        return ConfigTools3.getInt("crypt.v30.algorithm.type", IJMConstants.ALGORITHM_AES);
    }

    public static String getAESKey() {
        return ConfigTools3.getString("crypt.v30.aes.key", "ZCZtaGFrY2tlOXZjMmpaQw==");
    }

    public static String getAESIVKey() {
        return ConfigTools3.getString("crypt.v30.aes.iv", "oDG&6zcgcpvqkgv6");
    }


    public static String getDefaultDllPath() {
        //set default dll path base os
        String os_name = System.getProperty("os.name").toLowerCase();
        if (os_name.contains("window")) {
            return "c:/tve/dll";
        } else {
            return "/tve/dll";
        }
    }

    public static void init() {
        String dllPath = ConfigTools3.getString("crypt.v30.dll.path", getDefaultDllPath());
        boolean ret = JMEncryptBox.initLoadDllPath(dllPath, new IJMLogImpl());
        logger.info("IJM Init ret:[{}],path[{}]", ret, dllPath);
        if (!ret) {
            throw new IllegalArgumentException(String.format("IJM DLL Load faild!path:%s", dllPath));
        }

    }

    public static boolean isCryptIJM(String protocol) {
        if (CryptProtocolVersion.PROT_ACM30.equalsIgnoreCase(Strings.nullToEmpty(protocol))) {
            return true;
        } else {
            return false;
        }
    }

    @Deprecated
    public static String encrypt(String msg) {
        int algorithmType = getIJMAlgorithm();
        try {
            StatTools.startSrvTimer("crypt.ijm.encrypt");
            String encryptMsg = JMEncryptBoxByRandom.encryptToBase64(msg, getIJMAlgorithm());
            if (!Strings.isNullOrEmpty(encryptMsg)) {
                return CryptAESIVTools.encrypt(encryptMsg, getAESKey(), getAESIVKey());
            } else {
                logger.error("IJM Encrypt failed:{} {}", algorithmType, msg);
            }
        } catch (Exception e) {
            logger.error("IJM Encrypt failed:{}", algorithmType, e);
        }
        finally {
            StatTools.stopSrvTimer("crypt.ijm.encrypt");
        }
        return "";
    }

    @Deprecated
    public static String decrypt(String msg) {
        int algorithmType = getIJMAlgorithm();
        try {

            String aesMsg = msg;
            msg = CryptAESIVTools.decrypt(aesMsg, getAESKey(), getAESIVKey());
            if (Strings.isNullOrEmpty(msg)) {
                logger.error("IJM Decrypt AES failed:[{}]", msg);
                return "";
            }

            ResultData resultData = JMEncryptBoxByRandom.decryptFromBase64(msg, algorithmType);
            if (resultData.getStatus() == IJMConstants.DECRYPT_STATUS_SUCCESS) {
                return resultData.getText();
            } else {
                logger.error("IJM Decrypt failed:{}{}", resultData.getStatus(), msg);
                return "";
            }

        } catch (Exception e) {
            logger.error("IJM Decrypt :{}", algorithmType, e);
            return "";
        }
    }


    public static String encryptV2(String protocol, String msg) {
        StatTools.startSrvTimer("crypt.ijm.encrypt");
        int algorithmType = getIJMAlgorithm();
        try {

            String encryptMsg = JMEncryptBoxByRandom.encryptToBase64(msg, getIJMAlgorithm());
            if (!Strings.isNullOrEmpty(encryptMsg)) {
                return CryptAESIVTools.encrypt(protocol, encryptMsg);
            } else {
                logger.error("IJM Encrypt failed:{} {}", algorithmType, msg);
            }
        } catch (Exception e) {
            logger.error("IJM Encrypt failed:{}", algorithmType, e);
        }
        finally {
            StatTools.stopSrvTimer("crypt.ijm.encrypt");
        }
        return "";
    }

    public static String decryptV2(String protocol, String msg) {
        int algorithmType = getIJMAlgorithm();
        try {
            String aesMsg = msg;
            msg = CryptAESIVTools.decrypt(protocol, aesMsg);
            if (Strings.isNullOrEmpty(msg)) {
                logger.error("IJM Decrypt AES failed:[{}]", msg);
                return "";
            }

            ResultData resultData = JMEncryptBoxByRandom.decryptFromBase64(msg, algorithmType);
            if (resultData.getStatus() == IJMConstants.DECRYPT_STATUS_SUCCESS) {
                return resultData.getText();
            } else {
                logger.error("IJM Decrypt failed:{}{}", resultData.getStatus(), msg);
                return "";
            }

        } catch (Exception e) {
            logger.error("IJM Decrypt :{}", algorithmType, e);
            return "";
        }
    }


    public static String sign(String msg) {
        return Hashing.sha1().hashString(msg, Charsets.UTF_8).toString();
    }
}
