/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.statistics.scheduler;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import common.base.tools.stat.StatTools;
import common.base.tools.statistics.CountStatisticsTools2;
import common.base.tools.statistics.MetricTools2;
import common.base.tools.statistics.StatTimeItem;
import common.base.tools.statistics.TimeStatisticsTools2;
import common.base.tools.sys.SystemTools;
import common.config.tools.config.ConfigTools3;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class WebApiStatisticsScheduler {
    private static final Logger logger = LoggerFactory.getLogger(WebApiStatisticsScheduler.class);
    static long lastReportTS = 0L;

    @Scheduled(fixedRate=3000L)
    public void statisticsScheduler() {
        long cycle = ConfigTools3.getLong((String)"api.statistics.cycle", (Long)60000L);
        if (System.currentTimeMillis() - lastReportTS > cycle) {
            this.reportAndPrint();
            lastReportTS = System.currentTimeMillis();
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void localStatisticsScheduler() {
        String msg = StatTools.dumpMutilline((boolean)false);
        if (!Strings.isNullOrEmpty((String)msg)) {
            logger.info("LOCAL-STAT:{}", (Object)msg);
        }
    }

    public void reportAndPrint() {
        if (ConfigTools3.getBoolean((String)"statistics.out.log", (boolean)true)) {
            boolean printPretty = ConfigTools3.getBoolean((String)"statistics.out.pretty", (boolean)true);
            String countStats = CountStatisticsTools2.dump((boolean)printPretty);
            String timeStats = TimeStatisticsTools2.dump((boolean)printPretty);
            if (!Strings.isNullOrEmpty((String)countStats) || !Strings.isNullOrEmpty((String)timeStats)) {
                logger.info("CountStats:{} TimeStats:{}", (Object)countStats, (Object)timeStats);
            }
        }
        if (ConfigTools3.getBoolean((String)"statistics.report", (boolean)false)) {
            this.reportCount2Metric();
            this.reportTime2Metric();
        }
        CountStatisticsTools2.clear();
        TimeStatisticsTools2.clear();
    }

    private void reportTime2Metric() {
        Map countMap = TimeStatisticsTools2.getTimeStatMap();
        countMap.forEach((k, v) -> {
            this.reportTimeConsumed(v.getKey(), v.getCount(), v.avg());
            ConfigTools3.getAsList((String)"statistics.level").forEach(s -> this.reportTimeConsumedByStatus((String)s, (StatTimeItem)v));
        });
    }

    private void reportCount2Metric() {
        Map countMap = CountStatisticsTools2.getCountData();
        countMap.forEach((k, v) -> v.forEach((k1, v1) -> this.reportCount(String.format("%s-%s", k, k1), (long)v1)));
    }

    private void reportCount(String key, long count) {
        String metricName = String.format("%s_count", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)key);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    private void reportTimeConsumed(String key, long count, long avg) {
        String metricName = String.format("%s_time_consumed", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)key);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count, (Object)"avg", (Object)avg);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    private void reportTimeConsumedByStatus(String key, StatTimeItem timeItem) {
        int level = ConfigTools3.getInt((String)String.format("statistics.level.%s", key), (Integer)0);
        if (level <= 0) {
            return;
        }
        long count = timeItem.getCountGELevel(level);
        if (count == 0L) {
            return;
        }
        String reportKey = String.format("%s.%s", timeItem.getKey(), key);
        String metricName = String.format("%s_time_status", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)reportKey);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }
}

