/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.errormsg;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLangTools {
    private static final Logger logger = LoggerFactory.getLogger(ErrorLangTools.class);
    public static String LANG_PT = "pt";
    public static String LANG_ES = "es";
    public static String LANG_EN = "en";
    public static String LANG_RU = "ru";
    public static String LANG_ES_TMDB_ALIAS = "spa";

    public static boolean isPortuguese(String language) {
        return LANG_PT.equalsIgnoreCase(language);
    }

    public static boolean isSpanish(String language) {
        return LANG_ES.equalsIgnoreCase(language);
    }

    public static boolean isEnglish(String language) {
        return LANG_EN.equalsIgnoreCase(language);
    }

    public static boolean isRussian(String language) {
        return LANG_RU.equalsIgnoreCase(language);
    }

    public static boolean isSupportLanguage(String language) {
        return ErrorLangTools.isEnglish(language) || ErrorLangTools.isPortuguese(language) || ErrorLangTools.isSpanish(language) || ErrorLangTools.isRussian(language);
    }

    public static String spanishAlias(String language) {
        if (LANG_ES_TMDB_ALIAS.equalsIgnoreCase(language)) {
            return LANG_ES;
        }
        return language;
    }

    public static boolean equalLanguage(String lang1, String lang2) {
        if (Strings.isNullOrEmpty((String)lang1) || Strings.isNullOrEmpty((String)lang2)) {
            return false;
        }
        if (lang1.equalsIgnoreCase(lang2)) {
            return true;
        }
        return (ErrorLangTools.isEnglish(lang1) || ErrorLangTools.isEnglish(lang2)) && ErrorLangTools.spanishAlias(lang1).equalsIgnoreCase(ErrorLangTools.spanishAlias(lang2));
    }

    public static String getOrDefaultLanguage(String language) {
        if (ErrorLangTools.isSupportLanguage(language)) {
            return language;
        }
        return LANG_EN;
    }
}

