package common.diagnosis.tools;

import com.google.common.collect.Maps;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;


/**
 * @author Frank.Huang
 */
@Controller
public class Diagnosis2Controller {
    private static final Logger logger = LoggerFactory.getLogger(Diagnosis2Controller.class);

    @Autowired
    private VersionConfig versionConfig;

    @ResponseBody
    @RequestMapping("/api/ping/v3")
    public Map<String, String> ping(HttpServletRequest httpRequest,
                                    HttpServletResponse httpResponse,
                                    @RequestParam(required = false, defaultValue = "0") int version,
                                    @RequestParam(required = false, defaultValue = "0") int runtime) {

        String clientIp = HttpTools.getRemoteHost(httpRequest);
        Map<String, String> response = Maps.newTreeMap();
        response.put("server.clientIp", clientIp);

        response.put("server.host", SystemTools.getHostnameMD5());
        Date dateNow = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));

        response.put("server.timestamp", dateNow.getTime() + "");
        response.put("server.time", simpleDateFormat.format(dateNow));

        if (version == 1) {
            versionConfig.properties().entrySet().forEach(e -> {
                response.put((String) e.getKey(), (String) e.getValue());
            });
        }

        if (runtime == 1) {
            System.getProperties().entrySet().forEach(e -> {
                String key = (String) e.getKey();
                if (key.startsWith("java.vm.")
                        || key.startsWith("java.runtime.")
                        || key.startsWith("java.specification.")
                        || key.startsWith("os.")
                        || key.startsWith("user.country")
                        || key.startsWith("user.timezone")) {
                    response.put(String.format("runtime.%s", key), (String) e.getValue());
                }

            });
        }

        return response;
    }
}
