package common.diagnosis.tools;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

import java.util.Properties;

/**
 * @author Frank.Huang
 */
@Configuration
//@ConfigurationProperties(prefix = "version")
@PropertySource(value = "classpath:version.properties", ignoreResourceNotFound = false)
public class VersionConfig {
    @Value(value = "${version.buildNumber:NA}")
    private String buildNumber = "";
    @Value(value = "${version.buildBy:NA}")
    private String buildBy = "";
    @Value(value = "${version.buildTime:NA}")
    private String buildTime = "";
    @Value(value = "${version.buildEnv:NA}")
    private String buildEnv = "";
    @Value(value = "${version.buildJdk:NA}")
    private String buildJdk = "";
    @Value(value = "${version.buildImplVersion:NA}")
    private String buildImplVersion = "";

    private Properties properties = new Properties();

    public Properties properties() {
        properties.setProperty("version.buildNumber", buildNumber);
        properties.setProperty("version.buildBy", buildBy);
        properties.setProperty("version.buildTime", buildTime);
        properties.setProperty("version.buildEnv", buildEnv);
        properties.setProperty("version.buildJdk", buildJdk);
        properties.setProperty("version.buildImplVersion", buildImplVersion);

        return properties;
    }

    public String getBuildNumber() {
        return buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getBuildBy() {
        return buildBy;
    }

    public void setBuildBy(String buildBy) {
        this.buildBy = buildBy;
    }

    public String getBuildTime() {
        return buildTime;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    public String getBuildEnv() {
        return buildEnv;
    }

    public void setBuildEnv(String buildEnv) {
        this.buildEnv = buildEnv;
    }

    public String getBuildJdk() {
        return buildJdk;
    }

    public void setBuildJdk(String buildJdk) {
        this.buildJdk = buildJdk;
    }

    public String getBuildImplVersion() {
        return buildImplVersion;
    }

    public void setBuildImplVersion(String buildImplVersion) {
        this.buildImplVersion = buildImplVersion;
    }
}
