package common.diagnosis.springboot.starter.tools;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;

import javax.servlet.http.HttpServletRequest;

public class HttpTools {

    private static ImmutableList<String> ipHeaderNameList = ImmutableList.<String>builder()
            .add("x-forwarded-for")
            .add("CF-Connecting-IP")
            .add("Proxy-Client-IP")
            .add("WL-Proxy-Client-IP")

            .add("X-Forwarded-For")
            .add("HTTP_X_REAL_IP")
            .add("HTTP_CLIENT_IP")
            .add("HTTP_X_FORWARDED_FOR")

            .build();


    private static boolean isInvalidClientIp(String clientIp) {
        if (Strings.isNullOrEmpty(clientIp)) {
            return false;
        }

        if ("unknown".equalsIgnoreCase(clientIp)) {
            return false;
        }

        return true;
    }

    public static String getRemoteHost(HttpServletRequest request) {

        /*
           Get real client ip,support CloudFlare,Aliyun,AWS proxy
         */
        String realClientIp = null;
        for (String headerName : ipHeaderNameList) {
            realClientIp = request.getHeader(headerName);
            if (isInvalidClientIp(realClientIp)) {
                break;
            }
        }

        //CAN NOT get from header,get from request
        if (!isInvalidClientIp(realClientIp)) {
            realClientIp = request.getRemoteAddr();
        }

        //对于通过多个代理的情况，第一个IP为客户端真实IP,多个IP按照','分割
        if (!Strings.isNullOrEmpty(realClientIp)) {
            if (realClientIp.indexOf(",") > 0) {
                realClientIp = realClientIp.substring(0, realClientIp.indexOf(","));
            }
        }

        return Strings.nullToEmpty(realClientIp);
    }

    public static String getClientRegion(HttpServletRequest request) {
        return Strings.nullToEmpty(request.getHeader("CF-IPCountry"));
    }

}
