/*
 * Decompiled with CFR 0.152.
 */
package common.diagnosis.springboot.starter.buildinfo;

import com.google.common.collect.Maps;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;

public class BuildInfoProperties {
    private final Logger logger = LoggerFactory.getLogger(BuildInfoProperties.class);
    private Map<String, String> properties = Maps.newLinkedHashMap();

    public BuildInfoProperties(GitProperties gitProperties, BuildProperties buildProperties) {
        if (Objects.nonNull(buildProperties)) {
            this.properties.put("package.build.name", buildProperties.getArtifact());
            this.properties.put("package.build.group", buildProperties.getGroup());
            this.properties.put("package.build.artifact", buildProperties.getArtifact());
            this.properties.put("package.build.version", buildProperties.getVersion());
            this.properties.put("package.build.time", this.formatInstant(buildProperties.getTime()));
        }
        if (Objects.nonNull(gitProperties)) {
            this.properties.put("code.commit.branch", gitProperties.getBranch());
            this.properties.put("code.commit.id", gitProperties.getShortCommitId());
            this.properties.put("code.commit.user.name", gitProperties.get("commit.user.name"));
            this.properties.put("code.commit.time", this.formatInstant(gitProperties.getCommitTime()));
            this.properties.put("code.build.time", this.formatInstant(gitProperties.getInstant("build.time")));
            this.properties.put("code.build.host", gitProperties.get("build.host"));
        }
        System.getProperties().entrySet().forEach(e -> {
            String key = (String)e.getKey();
            if (key.startsWith("java.vm.") || key.startsWith("java.runtime.") || key.startsWith("java.specification.") || key.startsWith("os.") || key.startsWith("user.country") || key.startsWith("user.timezone")) {
                this.properties.put(String.format("runtime.%s", key), (String)e.getValue());
            }
        });
        this.printfBuildInfoProperties();
    }

    public Map<String, String> buildInfoProperties() {
        return this.properties;
    }

    public Map<String, String> buildInfoProperties(String prefix) {
        return this.properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    }

    public void printfBuildInfoProperties() {
        this.properties.entrySet().forEach(e -> this.logger.info("{}={}", e.getKey(), e.getValue()));
    }

    private String formatInstant(Instant instant) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.of("Asia/Shanghai")).format(instant);
    }
}

