/*
 * Decompiled with CFR 0.152.
 */
package common.diagnosis.springboot.starter.controller;

import com.google.common.collect.Maps;
import common.diagnosis.springboot.starter.buildinfo.BuildInfoProperties;
import common.diagnosis.springboot.starter.tools.HttpTools;
import common.diagnosis.springboot.starter.tools.SystemTools;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ConditionalOnWebApplication
public class DiagnosisControllerV3 {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisControllerV3.class);
    @Autowired
    private BuildInfoProperties buildProperties;

    @ResponseBody
    @RequestMapping(value={"/api/ping/v3"})
    public Map<String, String> pingV3(HttpServletRequest httpRequest, HttpServletResponse httpResponse, @RequestParam(required=false, defaultValue="0") int version, @RequestParam(required=false, defaultValue="0") int runtime) {
        String clientIp = HttpTools.getRemoteHost(httpRequest);
        TreeMap response = Maps.newTreeMap();
        response.put("server.clientIp", clientIp);
        response.put("server.host", SystemTools.getHostNameAES());
        Date dateNow = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        response.put("server.timestamp", dateNow.getTime() + "");
        response.put("server.time", simpleDateFormat.format(dateNow));
        if (version == 1 && Objects.nonNull(this.buildProperties)) {
            this.buildProperties.buildInfoProperties("code.").forEach((k, v) -> response.put(k, v));
            this.buildProperties.buildInfoProperties("package.").forEach((k, v) -> response.put(k, v));
        }
        if (runtime == 1 && Objects.nonNull(this.buildProperties)) {
            this.buildProperties.buildInfoProperties("runtime.").forEach((k, v) -> response.put(k, v));
        }
        return response;
    }
}

