/*
 * Decompiled with CFR 0.152.
 */
package common.diagnosis.springboot.starter.tools;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import javax.servlet.http.HttpServletRequest;

public class HttpTools {
    private static ImmutableList<String> ipHeaderNameList = ImmutableList.builder().add((Object)"x-forwarded-for").add((Object)"CF-Connecting-IP").add((Object)"Proxy-Client-IP").add((Object)"WL-Proxy-Client-IP").add((Object)"X-Forwarded-For").add((Object)"HTTP_X_REAL_IP").add((Object)"HTTP_CLIENT_IP").add((Object)"HTTP_X_FORWARDED_FOR").build();

    private static boolean isInvalidClientIp(String clientIp) {
        if (Strings.isNullOrEmpty((String)clientIp)) {
            return false;
        }
        return !"unknown".equalsIgnoreCase(clientIp);
    }

    public static String getRemoteHost(HttpServletRequest request) {
        String headerName;
        String realClientIp = null;
        UnmodifiableIterator unmodifiableIterator = ipHeaderNameList.iterator();
        while (unmodifiableIterator.hasNext() && !HttpTools.isInvalidClientIp(realClientIp = request.getHeader(headerName = (String)unmodifiableIterator.next()))) {
        }
        if (!HttpTools.isInvalidClientIp(realClientIp)) {
            realClientIp = request.getRemoteAddr();
        }
        if (!Strings.isNullOrEmpty(realClientIp) && realClientIp.indexOf(",") > 0) {
            realClientIp = realClientIp.substring(0, realClientIp.indexOf(","));
        }
        return Strings.nullToEmpty((String)realClientIp);
    }

    public static String getClientRegion(HttpServletRequest request) {
        return Strings.nullToEmpty((String)request.getHeader("CF-IPCountry"));
    }
}

