package common.diagnosis.springboot.starter.buildinfo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BuildInfoPropertiesAutoConfiguration {
    @Autowired
    private GitProperties gitProperties;

    @Autowired
    private BuildProperties buildProperties;

    @Bean
    @ConditionalOnMissingBean(BuildInfoProperties.class)
    public BuildInfoProperties buildInfoProperties() {
        return new BuildInfoProperties(gitProperties, buildProperties);
    }
}
