/*
 * Decompiled with CFR 0.152.
 */
package common.diagnosis.springboot.starter.tools;

import com.google.common.io.BaseEncoding;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESIVTools {
    private static final Logger logger = LoggerFactory.getLogger(AESIVTools.class);

    public static byte[] encrypt(byte[] input, byte[] key, byte[] iv) {
        byte[] crypted = null;
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)skey, ivSpec);
            crypted = cipher.doFinal(input);
        }
        catch (Exception e) {
            logger.error("AESIVTools.encrypt", (Throwable)e);
        }
        return crypted;
    }

    public static byte[] decrypt(byte[] input, byte[] key, byte[] iv) {
        try {
            byte[] output = null;
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)skey, ivSpec);
            output = cipher.doFinal(input);
            return output;
        }
        catch (Exception e) {
            logger.error("AESIVTools.decrypt", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String input, String key, String iv) {
        byte[] keyBytes = BaseEncoding.base64().decode((CharSequence)key);
        byte[] crypted = AESIVTools.encrypt(input.getBytes(), keyBytes, iv.getBytes());
        return BaseEncoding.base64Url().encode(crypted);
    }

    public static String decrypt(String input, String key, String iv) {
        byte[] keyBytes;
        byte[] inputBytes = BaseEncoding.base64().decode((CharSequence)input);
        byte[] bytes = AESIVTools.decrypt(inputBytes, keyBytes = BaseEncoding.base64().decode((CharSequence)key), iv.getBytes());
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }
}

