package com.valor.common.flowcontrol.client.constant;

import com.common.web.tools.ErrorMsgBuilder;

/**
 * @author Hunter Chen
 * created on: 2018-09-11
 */
public enum EFlowControlResultCode {
    
    SUCCESS(0,"Success"),
    OUT_OF_LIMIT(1,"Out of limit"),
    INIT_ERROR(2,"Not init or init error"),
    NOT_CONFIG(3,"Not Config"),
    INVALID_APPID(4,"Invalid App info"),
    HTTP_ERROR(5,"Connection to flow control server error")

    ;

    private int errorCode;
    private String message;
    private int returnCode=1008;

    EFlowControlResultCode(int errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public String getMessage() {
        return ErrorMsgBuilder.buildErrMsg(null,null,returnCode,errorCode,message);
    }

    public int getReturnCode() {
        if (errorCode == 0){
            return 0;
        }else {
            return returnCode;
        }
    }
}
