package com.valor.common.flowcontrol.client.model;

import com.google.common.base.Strings;
import common.base.tools.AbstractPrintable;

/**
 * @author Hunter Chen
 * created on: 2018-09-10
 * <p>
 * The configuration for flow control. All fields must be set when initialized.
 */
public class FlowControlConfigItem extends AbstractPrintable {

    /**
     * Any token that represents the api that’s calling the flow control service. Must be unique within the same module.
     * Recommend using the calling method’s name. e.g. "login". If it's ambiguous, you might include full method signatures, like "login(String username)"
     * Or you can use "loginService.login(String username)".
     */
    private String key;

    /**
     * monitoring period. For example, if you want an ip to visit this method no more than 10 times in one minute
     * you should set the limit above as 10, and intervalSeconds as 60
     *
     * The blacklist time after being blacklisted is the remainder of the intervalSeconds.
     * For example, if the above visitor(ip) visited 10 times at 21 seconds mark, he'll be forbid to visit this method
     * for the remaining 60-21=39 seconds
     */
    
    private int intervalSeconds;

    /**
     * The number of times allowed for visits before visitor is blacklisted
     */
    private int limit;


    /**
     * Mode for flow control.
     *
     * set value as 1 for cumulative mode, 2 for deduplicate mode.
     *
     * cumulative mode: for a certain method or api or any other token, each visit from visitor counts. Thus "cumulative"
     * Example, we want to limit each ip can only invoke "login" method of MFC-Cloud 10 times within 60 seconds, we should use this form
     *
     * deduplicate mode: In this mode, we have two values, value_1 and value_2. It limits how many different values_2 binds to value_1,
     * within a time-frame.
     *
     * Example: we want to limit the number unique of mac address bind to one ip to five, within 24 hours. We set ip as level_1_value,
     * mac as level_2_value.
     */
    private int mode;


    //sync:0 async:1
    private int async;


    public FlowControlConfigItem(String key, int limit, int intervalSeconds, int mode) {
        this.key = key;
        this.limit = limit;
        this.intervalSeconds = intervalSeconds;
        this.mode = mode;
    }

    public FlowControlConfigItem() {
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getIntervalSeconds() {
        return intervalSeconds;
    }

    public void setIntervalSeconds(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public int getMode() {
        return mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getAsync() {
        return async;
    }

    public void setAsync(int async) {
        this.async = async;
    }

    public boolean isValid(){
        if (Strings.isNullOrEmpty(key)){
            return false;
        }

        if (intervalSeconds ==0){
            return false;
        }

        if (limit == 0){
            return false;
        }

        if (mode == 0){
            return false;
        }

        return true;
    }
}
