package com.valor.common.flowcontrol.client.service.impl.api;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.valor.common.flowcontrol.client.constant.EFlowControlResultCode;
import com.valor.common.flowcontrol.client.model.*;
import com.valor.common.flowcontrol.client.service.ResponseBuilder;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;

import java.util.List;

public class FlowControlApi implements IFlowControlApi {

    private static final String URL_INIT_TPL = "%s/api/flowControl/init/v1";
    private static final String URL_COUNTER_TPL = "%s/api/flowControl/counter/v1";
    private static final String URL_COUNTER_UNIQUE_TPL = "%s/api/flowControl/uniqueCounter/v1";

    private FlowControlConfigClient configClient;
    List<String> serverHosts = Lists.newArrayList();

    public FlowControlApi(FlowControlConfigClient config) {
        this.configClient = config;
        serverHosts = Splitter.on(";").omitEmptyStrings().splitToList(config.getServerHost());
        RestCallClient.init(config.getMaxConnectionTotal(), config.getMaxConnectionPerRoute(), config.getTimeout());
    }

    @Override
    public WebApiBaseResponse init(FlowControlConfigServer config) {
        WebApiBaseResponse response = RestCallSync.postSync(buildServerUrl(URL_INIT_TPL), config, WebApiBaseResponse.class);
        return processResponse(response);
    }

    @Override
    public WebApiResponse<FlowControlBaseRsp> counter(FlowControlCounterReq counterReq) {
        WebApiResponse<FlowControlBaseRsp> response = new WebApiResponse<>();
        response = RestCallSync.postSync(buildServerUrl(URL_COUNTER_TPL), counterReq, response.getClass());
        return processResponse(response);
    }

    @Override
    public WebApiResponse<FlowControlBaseRsp> uniqueCounter(FlowControlUniqueCounterReq counterReq) {
        WebApiResponse<FlowControlBaseRsp> response = new WebApiResponse<>();
        response = RestCallSync.postSync(buildServerUrl(URL_COUNTER_UNIQUE_TPL), counterReq, response.getClass());
        return processResponse(response);
    }

    @Override
    public void counterAsync(FlowControlCounterReq counterReq, RestCallAsyncCallback callBack) {
        WebApiResponse<FlowControlBaseRsp> response = new WebApiResponse<>();
        RestCallAsync.postAsync(buildServerUrl(URL_COUNTER_TPL), counterReq, response.getClass(), callBack);
    }

    @Override
    public void uniqueCounterAsync(FlowControlUniqueCounterReq counterReq, RestCallAsyncCallback callBack) {
        WebApiResponse<FlowControlBaseRsp> response = new WebApiResponse<>();
        Class responseType = response.getClass();
//        ParameterizedTypeReference<WebApiResponse<FlowControlBaseRsp>> responseType = new ParameterizedTypeReference<WebApiResponse<FlowControlBaseRsp>>() {};

        RestCallAsync.postAsync(buildServerUrl(URL_COUNTER_UNIQUE_TPL), counterReq, responseType, callBack);
    }


    private String selectServerHost() {
        int serverHost = serverHosts.size();
        int index = (int) (System.nanoTime() % serverHost);
        return serverHosts.get(index);
    }

    private String buildServerUrl(String tpl) {
        return String.format(tpl, selectServerHost());
    }

    public WebApiBaseResponse processResponse(WebApiBaseResponse response) {
        if (response == null) {
            response = ResponseBuilder.buildResponse(EFlowControlResultCode.HTTP_ERROR);
        }

        return response;
    }

    public WebApiResponse processResponse(WebApiResponse response) {
        if (response == null) {
            response = ResponseBuilder.buildResponseWithResult(EFlowControlResultCode.HTTP_ERROR);
        }

        return response;
    }


}
