package com.valor.common.flowcontrol.client.service.impl.api;

import com.valor.common.flowcontrol.client.model.FlowControlBaseRsp;
import com.valor.common.flowcontrol.client.model.FlowControlConfigServer;
import com.valor.common.flowcontrol.client.model.FlowControlCounterReq;
import com.valor.common.flowcontrol.client.model.FlowControlUniqueCounterReq;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;

public interface IFlowControlApi {
    /**
     * Init flow control server
     * @param config
     * @return
     */
    WebApiBaseResponse init(FlowControlConfigServer config);

    /**
     * counter sync
     * @param counterReq
     * @return
     */
    WebApiResponse<FlowControlBaseRsp> counter(FlowControlCounterReq counterReq);

    /**
     * Counter without sync
     * @param counterReq
     * @return
     */
    WebApiResponse<FlowControlBaseRsp> uniqueCounter(FlowControlUniqueCounterReq counterReq);

    /**
     * Counter async
     * @param counterReq
     * @param callBack
     */
    void counterAsync(FlowControlCounterReq counterReq, RestCallAsyncCallback callBack);

    /**
     * Counter without async
     * @param counterReq
     * @param callBack
     */
    void uniqueCounterAsync(FlowControlUniqueCounterReq counterReq, RestCallAsyncCallback callBack);
}
