package com.valor.common.flowcontrol.client.service.impl.flowcontrol;

import com.valor.common.flowcontrol.client.constant.EFlowControlResultCode;
import com.valor.common.flowcontrol.client.model.FlowControlBaseRsp;
import com.valor.common.flowcontrol.client.service.impl.api.RestCallAsyncCallback;
import com.valor.common.flowcontrol.client.service.impl.cache.CacheFactory;
import common.web.tools.http.model.response.WebApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import java.util.Map;

public class FlowControlAsyncCallBack extends RestCallAsyncCallback<WebApiResponse<FlowControlBaseRsp>> {
    private static Logger logger = LoggerFactory.getLogger(FlowControlAsyncCallBack.class);

    @Override
    public void onSuccess(ResponseEntity<WebApiResponse<FlowControlBaseRsp>> result) {
        try {
            super.onSuccess(result);
            if (result.getStatusCode() == HttpStatus.OK) {
                WebApiResponse<FlowControlBaseRsp> response = result.getBody();
                if (!response.isSuccessful()) {
                    if (response.getErrCode() == EFlowControlResultCode.OUT_OF_LIMIT.getErrorCode()) {
                        Map<String, String> responseResultMap = (Map<String, String>) response.getResult();

                        String l1Key = responseResultMap.get("l1Key");
                        String l2Key = responseResultMap.get("l2Key");
                        //check if already out of limit
                        String fcKey = FlowControlKeyBuilder.buildKey(FlowControlClient.getIntervalSeconds(l1Key), l1Key, l2Key);

                        CacheFactory.addOutOfLimit(fcKey);
                        logger.info("Out of limit:{}", fcKey);
                    }
                }
            }
        } catch (Exception e) {
            super.onFailure(e);
        }
    }

    @Override
    public void onFailure(Throwable ex) {
        super.onFailure(ex);
    }
}
