package com.valor.common.flowcontrol.client.service.impl.flowcontrol;

import com.google.common.base.Joiner;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FlowControlKeyBuilder {
    private static final long SECONDS_FROM_20181111 = 1541865600000L;

    private static long getTimeMillisFrom20181111() {
        return System.currentTimeMillis() - SECONDS_FROM_20181111;
    }

    public static String buildKey(int periodSecond, String... keys) {

        long now = System.currentTimeMillis();
        long time = now - (now % (long) (periodSecond*1000));
        SimpleDateFormat sdf = new SimpleDateFormat("ssmmHHddMMyy");
        
        String key = Joiner.on("#").join(keys);
        return String.format("%s#%s", sdf.format(new Date(time)), key);
    }
}
