package com.valor.common.flowcontrol.client.web.annotation.processor;


import com.google.common.base.Strings;
import com.valor.common.flowcontrol.client.web.annotation.WebApiRateLimit;
import com.valor.common.flowcontrol.client.constant.FlowControlConstant;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlClient;
import common.base.tools.exception.ApiException;
import common.web.tools.http.HttpTools;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.webapi.processor.WebApiCallInterceptor;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


/**
 * Created by Frank.Huang on 2016/6/20.
 */
@Service
@Aspect
public class WebApiRateLimitInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiCallInterceptor.class);


    @Pointcut(value = "@annotation(com.valor.common.flowcontrol.client.web.annotation.WebApiRateLimit)")
    public void webApiRateLimit() {
    }

    @Around(value = "com.valor.common.flowcontrol.client.web.annotation.processor.WebApiRateLimitInterceptor&&@annotation(webApiRateLimit)")
    public Object apiRun(ProceedingJoinPoint pjp, WebApiRateLimit webApiRateLimit) throws ServletException, IOException, ApiException {

        HttpServletRequest request = getRequest(pjp);
        String apiName = webApiRateLimit.name();
        if (Strings.isNullOrEmpty(apiName)) {
            apiName = HttpTools.getApiPath(request);
        }

        Object retVal = null;
        try {
            String clientIp = HttpTools.getRemoteHost(request);
            String flowControlKey = FlowControlClient.getFlowControlApi(apiName);
            if (!Strings.isNullOrEmpty(flowControlKey)) {
                WebApiBaseResponse resp = FlowControlClient.counter(flowControlKey, clientIp);
                if (FlowControlClient.isOutOfLimit(resp)) {
                    //429:Too Many Requests
                    HttpServletResponse response = getResponse(pjp);
                    response.setStatus(FlowControlConstant.HTTP_CODE_TOO_MANY_REQUESTS);
                    return null;
                }
            }

            retVal = pjp.proceed();
        } catch (Throwable throwable) {
            logger.error("API:[{}] Exception:[{}]", apiName, throwable.toString());
            throw new ApiException(-999, -999, "Internal error");
        }

        return retVal;

    }

    public HttpServletRequest getRequest(JoinPoint jp) {
        return (HttpServletRequest) jp.getArgs()[0];
    }

    public HttpServletResponse getResponse(JoinPoint jp) {
        return (HttpServletResponse) jp.getArgs()[1];
    }

}
