package com.valor.common.flowcontrol.client.web.filter;

import com.google.common.base.Strings;
import com.valor.common.flowcontrol.client.constant.FlowControlConstant;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlClient;
import common.web.tools.http.HttpTools;
import common.web.tools.http.model.response.WebApiBaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Flow control filter
 *  Control api request rate,use client ip as control item
 */
public class FlowControlFilter extends OncePerRequestFilter {
    private static Logger logger = LoggerFactory.getLogger(FlowControlFilter.class);

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
        throws ServletException, IOException {
        String apiName = HttpTools.getRequestURI(request);

        //ping2 not control rate
        if (isNeedFlowCtrl(apiName)) {
            String flowControlKey = FlowControlClient.getFlowControlApi(apiName);
            if (!Strings.isNullOrEmpty(flowControlKey)) {
                String clientIp = HttpTools.getRemoteHost(request);
                WebApiBaseResponse resp = FlowControlClient.counter(flowControlKey, clientIp);
                if (FlowControlClient.isOutOfLimit(resp)) {
                    //return 429:Too Many Requests
                    response.setStatus(FlowControlConstant.HTTP_CODE_TOO_MANY_REQUESTS);
                    logger.error("API:[{}] client ip:[{}] [429:Too Many Requests]", apiName, clientIp);
                    return;
                }
            }
        }

        
        filterChain.doFilter(request, response);
    }


    private boolean isNeedFlowCtrl(String apiName) {
        if (Strings.isNullOrEmpty(apiName)) {
            return false;
        }

        //skip ping api (api/ping/v1,api/ping2)
        if ("api_ping_v1".equalsIgnoreCase(apiName) || "api_ping2".equalsIgnoreCase(apiName)) {
            return false;
        }

        return true;
    }
}
