/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.service;

import com.valor.common.flowcontrol.client.constant.EFlowControlResultCode;
import com.valor.common.flowcontrol.client.model.FlowControlBaseRsp;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;

public class ResponseBuilder {
    public static WebApiBaseResponse buildResponse(int retCode, int errCode, String message) {
        WebApiBaseResponse response = new WebApiBaseResponse();
        if (errCode == 0) {
            response.setRetCode(0);
        } else {
            response.setRetCode(retCode);
        }
        response.setErrCode(errCode);
        response.setMessage(message);
        return response;
    }

    public static WebApiBaseResponse buildResponse(EFlowControlResultCode retCode) {
        return ResponseBuilder.buildResponse(retCode.getReturnCode(), retCode.getErrorCode(), retCode.getMessage());
    }

    public static WebApiResponse buildResponseWithResult(EFlowControlResultCode retCode) {
        WebApiResponse response = new WebApiResponse();
        response.setRetCode(retCode.getReturnCode());
        response.setErrCode(retCode.getErrorCode());
        response.setMessage(retCode.getMessage());
        return response;
    }

    public static WebApiResponse buildResponseOutOfLimit(String appId, String l1Key, String l2key) {
        WebApiResponse response = new WebApiResponse();
        response.setRetCode(EFlowControlResultCode.OUT_OF_LIMIT.getReturnCode());
        response.setErrCode(EFlowControlResultCode.OUT_OF_LIMIT.getErrorCode());
        response.setMessage(EFlowControlResultCode.OUT_OF_LIMIT.getMessage());
        FlowControlBaseRsp flowControlBaseRsp = new FlowControlBaseRsp();
        flowControlBaseRsp.setAppId(appId);
        flowControlBaseRsp.setL1Key(l1Key);
        flowControlBaseRsp.setL2Key(l2key);
        response.setResult((Object)flowControlBaseRsp);
        return response;
    }
}

