/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.service.impl.api;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.valor.common.flowcontrol.client.constant.EFlowControlResultCode;
import com.valor.common.flowcontrol.client.model.FlowControlBaseRsp;
import com.valor.common.flowcontrol.client.model.FlowControlConfigClient;
import com.valor.common.flowcontrol.client.model.FlowControlConfigServer;
import com.valor.common.flowcontrol.client.model.FlowControlCounterReq;
import com.valor.common.flowcontrol.client.model.FlowControlUniqueCounterReq;
import com.valor.common.flowcontrol.client.service.ResponseBuilder;
import com.valor.common.flowcontrol.client.service.impl.api.IFlowControlApi;
import com.valor.common.flowcontrol.client.service.impl.api.RestCallAsync;
import com.valor.common.flowcontrol.client.service.impl.api.RestCallAsyncCallback;
import com.valor.common.flowcontrol.client.service.impl.api.RestCallClient;
import com.valor.common.flowcontrol.client.service.impl.api.RestCallSync;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;
import java.util.List;

public class FlowControlApi
implements IFlowControlApi {
    private static final String URL_INIT_TPL = "%s/api/flowControl/init/v1";
    private static final String URL_COUNTER_TPL = "%s/api/flowControl/counter/v1";
    private static final String URL_COUNTER_UNIQUE_TPL = "%s/api/flowControl/uniqueCounter/v1";
    private FlowControlConfigClient configClient;
    List<String> serverHosts = Lists.newArrayList();

    public FlowControlApi(FlowControlConfigClient config) {
        this.configClient = config;
        this.serverHosts = Splitter.on((String)";").omitEmptyStrings().splitToList((CharSequence)config.getServerHost());
        RestCallClient.init(config.getMaxConnectionTotal(), config.getMaxConnectionPerRoute(), config.getTimeout());
    }

    @Override
    public WebApiBaseResponse init(FlowControlConfigServer config) {
        WebApiBaseResponse response = RestCallSync.postSync(this.buildServerUrl(URL_INIT_TPL), config, WebApiBaseResponse.class);
        return this.processResponse(response);
    }

    @Override
    public WebApiResponse<FlowControlBaseRsp> counter(FlowControlCounterReq counterReq) {
        WebApiResponse response = new WebApiResponse();
        response = (WebApiResponse)RestCallSync.postSync(this.buildServerUrl(URL_COUNTER_TPL), counterReq, response.getClass());
        return this.processResponse(response);
    }

    @Override
    public WebApiResponse<FlowControlBaseRsp> uniqueCounter(FlowControlUniqueCounterReq counterReq) {
        WebApiResponse response = new WebApiResponse();
        response = (WebApiResponse)RestCallSync.postSync(this.buildServerUrl(URL_COUNTER_UNIQUE_TPL), counterReq, response.getClass());
        return this.processResponse(response);
    }

    @Override
    public void counterAsync(FlowControlCounterReq counterReq, RestCallAsyncCallback callBack) {
        WebApiResponse response = new WebApiResponse();
        RestCallAsync.postAsync(this.buildServerUrl(URL_COUNTER_TPL), counterReq, response.getClass(), callBack);
    }

    @Override
    public void uniqueCounterAsync(FlowControlUniqueCounterReq counterReq, RestCallAsyncCallback callBack) {
        WebApiResponse response = new WebApiResponse();
        Class<?> responseType = response.getClass();
        RestCallAsync.postAsync(this.buildServerUrl(URL_COUNTER_UNIQUE_TPL), counterReq, responseType, callBack);
    }

    private String selectServerHost() {
        int serverHost = this.serverHosts.size();
        int index = (int)(System.nanoTime() % (long)serverHost);
        return this.serverHosts.get(index);
    }

    private String buildServerUrl(String tpl) {
        return String.format(tpl, this.selectServerHost());
    }

    public WebApiBaseResponse processResponse(WebApiBaseResponse response) {
        if (response == null) {
            response = ResponseBuilder.buildResponse(EFlowControlResultCode.HTTP_ERROR);
        }
        return response;
    }

    public WebApiResponse processResponse(WebApiResponse response) {
        if (response == null) {
            response = ResponseBuilder.buildResponseWithResult(EFlowControlResultCode.HTTP_ERROR);
        }
        return response;
    }
}

