/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.service.impl.api;

import com.valor.common.flowcontrol.client.service.impl.api.RestCallAsyncCallback;
import com.valor.common.flowcontrol.client.service.impl.api.RestCallClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.client.AsyncRestTemplate;

public class RestCallAsync {
    private static Logger logger = LoggerFactory.getLogger(RestCallAsync.class);
    private static AsyncRestTemplate template = null;

    private static AsyncRestTemplate getRestClient() {
        if (template == null) {
            template = new AsyncRestTemplate((AsyncClientHttpRequestFactory)RestCallClient.AsyncHttpFactory());
        }
        return template;
    }

    public static <REQ, RSP> void postAsync(String url, REQ request, Class<RSP> responseType, RestCallAsyncCallback callback) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity(request, (MultiValueMap)headers);
            ListenableFuture future = RestCallAsync.getRestClient().postForEntity(url, entity, responseType, new Object[0]);
            future.addCallback((ListenableFutureCallback)callback);
        }
        catch (Exception e) {
            logger.error("AsyncRestTemplate:{}", (Throwable)e);
        }
    }
}

