/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.service.impl.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.Maps;
import com.valor.common.flowcontrol.client.model.FlowControlConfig;
import com.valor.common.flowcontrol.client.model.FlowControlConfigItem;
import com.valor.common.flowcontrol.client.service.impl.cache.FlowControlBlockCacheRemoveListener;
import com.valor.common.flowcontrol.client.service.impl.cache.FlowControlCacheRemoveListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactory {
    private static Logger logger = LoggerFactory.getLogger(CacheFactory.class);
    private static Map<String, Cache> cacheMap = Maps.newHashMap();
    private static Cache<String, Integer> blockCache = null;

    public static Map<String, Cache> getCacheMap() {
        return cacheMap;
    }

    public static void setCacheMap(Map<String, Cache> cacheMap) {
        CacheFactory.cacheMap = cacheMap;
    }

    public static Cache createCache(FlowControlConfigItem configItem, int batchTImeRatio) {
        String key = configItem.getKey();
        Cache cache = cacheMap.get(key);
        if (cache == null) {
            int batchTime = configItem.getIntervalSeconds() / batchTImeRatio;
            if (batchTime < 1) {
                batchTime = 1;
            }
            cache = CacheBuilder.newBuilder().expireAfterWrite((long)batchTime, TimeUnit.SECONDS).removalListener((RemovalListener)new FlowControlCacheRemoveListener(key, configItem.getMode())).build();
            cacheMap.put(key, cache);
        }
        return cache;
    }

    public static Cache getCache(String key) {
        Cache cache = cacheMap.get(key);
        return cache;
    }

    public static Cache<String, Integer> createBlockCache(int blockExpireSeconds) {
        if (blockCache != null) {
            return blockCache;
        }
        blockCache = CacheBuilder.newBuilder().expireAfterAccess((long)blockExpireSeconds, TimeUnit.SECONDS).removalListener((RemovalListener)new FlowControlBlockCacheRemoveListener()).build();
        return blockCache;
    }

    public static Cache<String, Integer> getBlockCache() {
        if (blockCache != null) {
            return blockCache;
        }
        return null;
    }

    public static void initCache(FlowControlConfig config) {
        int maxIntervalSeconds = 0;
        for (FlowControlConfigItem item : config.getServer().getFlowControlList()) {
            if (item.getIntervalSeconds() > maxIntervalSeconds) {
                maxIntervalSeconds = item.getIntervalSeconds();
            }
            CacheFactory.createCache(item, config.getClient().getBatchTimeRatio());
        }
        CacheFactory.createBlockCache(maxIntervalSeconds * 2);
    }

    public static boolean isOutOfLimit(String key) {
        Integer count = (Integer)blockCache.getIfPresent((Object)key);
        if (count == null) {
            return false;
        }
        count = count + 1;
        blockCache.put((Object)key, (Object)count);
        logger.info("Key[{}] is out of limit current[{}]", (Object)key, (Object)count);
        return true;
    }

    public static void addOutOfLimit(String key) {
        Integer count = (Integer)blockCache.getIfPresent((Object)key);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        blockCache.put((Object)key, (Object)count);
    }
}

