/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.service.impl.cache;

import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.valor.common.flowcontrol.client.model.FlowControlCounterReq;
import com.valor.common.flowcontrol.client.model.FlowControlUniqueCounterReq;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlClient;
import common.web.tools.http.model.response.WebApiBaseResponse;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControlCacheRemoveListener
implements RemovalListener {
    private static Logger logger = LoggerFactory.getLogger(FlowControlCacheRemoveListener.class);
    private String controlKey = "";
    private int mode = 0;

    public FlowControlCacheRemoveListener(String controlKey, int mode) {
        this.controlKey = controlKey;
        this.mode = mode;
    }

    public void onRemoval(RemovalNotification notification) {
        if (notification.wasEvicted()) {
            logger.info("{}:{}", (Object)notification.getCause(), (Object)notification);
            String appId = FlowControlClient.getConfig().getServer().getAppId();
            String appKey = FlowControlClient.getConfig().getServer().getAppKey();
            String key = (String)notification.getKey();
            if (this.mode == 1) {
                Integer count = (Integer)notification.getValue();
                FlowControlCounterReq req = new FlowControlCounterReq();
                req.setAppId(appId);
                req.setAppKey(appKey);
                req.setKey(this.controlKey);
                req.setValue(key);
                req.setCount(count);
                WebApiBaseResponse response = FlowControlClient.counterAsync(req);
                logger.info("RemoveListener send request:[{}#{}#{}#{}] response:{}", new Object[]{this.controlKey, this.mode, key, count, response});
            } else if (this.mode == 2) {
                Set countSet = (Set)notification.getValue();
                FlowControlUniqueCounterReq req = new FlowControlUniqueCounterReq();
                req.setAppId(appId);
                req.setAppKey(appKey);
                req.setKey(this.controlKey);
                req.setValue(key);
                req.setCount(countSet);
                WebApiBaseResponse response = FlowControlClient.uniqueCounterAsync(req);
                logger.info("RemoveListener send request:[{}#{}#{}#{}] response:{}", new Object[]{this.controlKey, this.mode, key, countSet.size(), response});
            }
        }
    }
}

