/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.service.impl.flowcontrol;

import com.valor.common.flowcontrol.client.constant.EFlowControlResultCode;
import com.valor.common.flowcontrol.client.model.FlowControlBaseRsp;
import com.valor.common.flowcontrol.client.service.impl.api.RestCallAsyncCallback;
import com.valor.common.flowcontrol.client.service.impl.cache.CacheFactory;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlClient;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlKeyBuilder;
import common.web.tools.http.model.response.WebApiResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class FlowControlAsyncCallBack
extends RestCallAsyncCallback<WebApiResponse<FlowControlBaseRsp>> {
    private static Logger logger = LoggerFactory.getLogger(FlowControlAsyncCallBack.class);

    @Override
    public void onSuccess(ResponseEntity<WebApiResponse<FlowControlBaseRsp>> result) {
        try {
            WebApiResponse response;
            super.onSuccess(result);
            if (result.getStatusCode() == HttpStatus.OK && !(response = (WebApiResponse)result.getBody()).isSuccessful() && response.getErrCode() == EFlowControlResultCode.OUT_OF_LIMIT.getErrorCode()) {
                Map responseResultMap = (Map)response.getResult();
                String l1Key = (String)responseResultMap.get("l1Key");
                String l2Key = (String)responseResultMap.get("l2Key");
                String fcKey = FlowControlKeyBuilder.buildKey(FlowControlClient.getIntervalSeconds(l1Key), l1Key, l2Key);
                CacheFactory.addOutOfLimit(fcKey);
                logger.info("Out of limit:{}", (Object)fcKey);
            }
        }
        catch (Exception e) {
            super.onFailure(e);
        }
    }

    @Override
    public void onFailure(Throwable ex) {
        super.onFailure(ex);
    }
}

