/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.service.impl.flowcontrol;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.valor.common.flowcontrol.client.constant.EFlowControlResultCode;
import com.valor.common.flowcontrol.client.model.FlowControlBaseRsp;
import com.valor.common.flowcontrol.client.model.FlowControlConfig;
import com.valor.common.flowcontrol.client.model.FlowControlConfigItem;
import com.valor.common.flowcontrol.client.model.FlowControlCounterReq;
import com.valor.common.flowcontrol.client.model.FlowControlUniqueCounterReq;
import com.valor.common.flowcontrol.client.service.ResponseBuilder;
import com.valor.common.flowcontrol.client.service.impl.api.FlowControlApi;
import com.valor.common.flowcontrol.client.service.impl.api.IFlowControlApi;
import com.valor.common.flowcontrol.client.service.impl.cache.CacheFactory;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlAsyncCallBack;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlKeyBuilder;
import common.config.tools.config.loader.json.JsonSerialize;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControlClient {
    private static Logger logger = LoggerFactory.getLogger(FlowControlClient.class);
    private static final int INIT_STATUS_SUCCESS = 0;
    private static final int INIT_STATUS_FAILED = 1;
    private static final int INIT_STATUS_EXCEPTION = 2;
    private static int initStatus = 1;
    private static int initCount = 0;
    private static IFlowControlApi flowControlApi = null;
    private static FlowControlConfig config = null;
    private static Map<String, FlowControlConfigItem> FlowControlConfigMap = Maps.newHashMap();
    private static String configFileName;

    public static WebApiBaseResponse init(String configFile) {
        configFileName = configFile;
        FlowControlClient.loadConfig(configFileName);
        if (config == null) {
            logger.error("Flow control not configured properly! Please fill in all the required configuration");
            return ResponseBuilder.buildResponse(EFlowControlResultCode.INIT_ERROR);
        }
        config.getServer().getFlowControlList().forEach(e -> {
            FlowControlConfigMap.put(e.getKey(), (FlowControlConfigItem)((Object)e));
            logger.info(e.toString());
        });
        CacheFactory.initCache(config);
        WebApiBaseResponse response = FlowControlClient.serverInit();
        return response;
    }

    public static WebApiBaseResponse counter(String key, String value, int count) {
        WebApiBaseResponse response = FlowControlClient.isAlreadyOutOfLimit(key, value);
        if (!response.isSuccessful()) {
            return response;
        }
        int size = FlowControlClient.addCounter(key, value, count, FlowControlClient.getBatchSize(key));
        if (size <= 0) {
            return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
        }
        FlowControlCounterReq counterReq = new FlowControlCounterReq();
        counterReq.setAppId(FlowControlClient.getConfig().getServer().getAppId());
        counterReq.setAppKey(FlowControlClient.getConfig().getServer().getAppKey());
        counterReq.setKey(key);
        counterReq.setValue(value);
        counterReq.setCount(size);
        response = FlowControlClient.checkServerInit();
        if (!response.isSuccessful()) {
            return response;
        }
        FlowControlConfigItem configItem = FlowControlConfigMap.get(key);
        if (configItem.getAsync() == 1) {
            flowControlApi.counterAsync(counterReq, new FlowControlAsyncCallBack());
            return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
        }
        WebApiResponse<FlowControlBaseRsp> fcsResponse = flowControlApi.counter(counterReq);
        String fcKey = FlowControlKeyBuilder.buildKey(FlowControlClient.getIntervalSeconds(key), key, value);
        return FlowControlClient.getWebApiBaseResponse(fcKey, fcsResponse);
    }

    public static WebApiBaseResponse counter(String key, String value) {
        return FlowControlClient.counter(key, value, 1);
    }

    public static WebApiBaseResponse counterAsync(FlowControlCounterReq counterReq) {
        WebApiBaseResponse response = FlowControlClient.checkServerInit();
        if (!response.isSuccessful()) {
            return response;
        }
        flowControlApi.counterAsync(counterReq, new FlowControlAsyncCallBack());
        return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
    }

    public static WebApiBaseResponse uniqueCounterAsync(FlowControlUniqueCounterReq counterReq) {
        WebApiBaseResponse response = FlowControlClient.checkServerInit();
        if (!response.isSuccessful()) {
            return response;
        }
        flowControlApi.uniqueCounterAsync(counterReq, new FlowControlAsyncCallBack());
        return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
    }

    public static WebApiBaseResponse uniqueCounter(String l1Key, String l2Key, Set<String> valueSet) {
        WebApiBaseResponse response = FlowControlClient.isAlreadyOutOfLimit(l1Key, l2Key);
        if (!response.isSuccessful()) {
            return response;
        }
        Set<String> uniqSet = FlowControlClient.addUniqueCounter(l1Key, l2Key, valueSet, FlowControlClient.getBatchSize(l1Key));
        if (uniqSet.isEmpty()) {
            return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
        }
        response = FlowControlClient.checkServerInit();
        if (!response.isSuccessful()) {
            return response;
        }
        FlowControlUniqueCounterReq uniqueCounter = new FlowControlUniqueCounterReq();
        uniqueCounter.setAppId(FlowControlClient.getConfig().getServer().getAppId());
        uniqueCounter.setAppId(FlowControlClient.getConfig().getServer().getAppKey());
        uniqueCounter.setKey(l1Key);
        uniqueCounter.setValue(l2Key);
        uniqueCounter.setCount(uniqSet);
        FlowControlConfigItem configItem = FlowControlConfigMap.get(l1Key);
        if (configItem.getAsync() == 1) {
            flowControlApi.uniqueCounterAsync(uniqueCounter, new FlowControlAsyncCallBack());
            return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
        }
        WebApiResponse<FlowControlBaseRsp> fcsResponse = flowControlApi.uniqueCounter(uniqueCounter);
        String fcKey = FlowControlKeyBuilder.buildKey(FlowControlClient.getIntervalSeconds(l1Key), l1Key, l2Key);
        return FlowControlClient.getWebApiBaseResponse(fcKey, fcsResponse);
    }

    public static WebApiBaseResponse uniqueCounter(String l1Key, String l2Key, String value) {
        return FlowControlClient.uniqueCounter(l1Key, l2Key, Sets.newHashSet((Object[])new String[]{value}));
    }

    private static WebApiBaseResponse getWebApiBaseResponse(String fcKey, WebApiResponse<FlowControlBaseRsp> fcsResponse) {
        if (fcsResponse.isSuccessful()) {
            return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
        }
        if (FlowControlClient.isOutOfLimit(fcsResponse)) {
            CacheFactory.addOutOfLimit(fcKey);
            return ResponseBuilder.buildResponse(EFlowControlResultCode.OUT_OF_LIMIT);
        }
        return fcsResponse;
    }

    public static FlowControlConfig getConfig() {
        return config;
    }

    public static void setConfig(FlowControlConfig config) {
        FlowControlClient.config = config;
    }

    private static FlowControlConfig loadConfig(String configFile) {
        TypeReference<FlowControlConfig> typeReference = new TypeReference<FlowControlConfig>(){};
        config = (FlowControlConfig)((Object)JsonSerialize.loadJson((File)new File(configFile), (TypeReference)typeReference));
        logger.info("Load config:{}", (Object)config);
        return config;
    }

    public static boolean isOutOfLimit(WebApiBaseResponse response) {
        return response.getErrCode() == EFlowControlResultCode.OUT_OF_LIMIT.getErrorCode();
    }

    public static int getIntervalSeconds(String key) {
        FlowControlConfigItem item = FlowControlConfigMap.get(key);
        if (item == null) {
            return -1;
        }
        return item.getIntervalSeconds();
    }

    public static int addCounter(String key, String value, int countSize, int batchSize) {
        Cache cache = CacheFactory.getCache(key);
        if (cache == null) {
            return -1;
        }
        Integer count = (Integer)cache.getIfPresent((Object)value);
        count = count == null ? Integer.valueOf(countSize) : Integer.valueOf(count + countSize);
        if (count < batchSize) {
            cache.put((Object)value, (Object)count);
            return 0;
        }
        cache.invalidate((Object)value);
        return count;
    }

    public static Set<String> addUniqueCounter(String l1Key, String l2Key, Set<String> valueSet, int batchSize) {
        Cache cache = CacheFactory.getCache(l1Key);
        if (cache == null) {
            return Sets.newHashSet();
        }
        Set uniqSet = (Set)cache.getIfPresent((Object)l2Key);
        if (uniqSet == null) {
            uniqSet = Sets.newHashSet();
        }
        uniqSet.addAll(valueSet);
        if (uniqSet.size() >= batchSize) {
            cache.invalidate((Object)l2Key);
            return uniqSet;
        }
        cache.put((Object)l1Key, (Object)uniqSet);
        return Sets.newHashSet();
    }

    public static int getBatchSize(String key) {
        FlowControlConfigItem configItem = FlowControlConfigMap.get(key);
        if (configItem == null) {
            return -1;
        }
        int batchSize = configItem.getLimit();
        if ((batchSize /= config.getClient().getBatchSizeRatio()) <= 0) {
            batchSize = 1;
        }
        return batchSize;
    }

    public static String getFlowControlApi(String apiPath) {
        if (FlowControlConfigMap.keySet().contains(apiPath)) {
            return apiPath;
        }
        String allModuleApi = String.format("api-%s", config.getServer().getAppId());
        if (FlowControlConfigMap.keySet().contains(allModuleApi)) {
            return allModuleApi;
        }
        return "";
    }

    private static WebApiBaseResponse serverInit() {
        flowControlApi = new FlowControlApi(config.getClient());
        WebApiBaseResponse response = flowControlApi.init(config.getServer());
        if (!response.isSuccessful()) {
            if (response.getErrCode() == EFlowControlResultCode.HTTP_ERROR.getErrorCode()) {
                initStatus = 2;
                ++initCount;
            } else {
                initStatus = 1;
            }
        }
        initStatus = 0;
        logger.info("Call to flowcontrol server init:{}", (Object)response);
        return response;
    }

    private static WebApiBaseResponse checkServerInit() {
        WebApiBaseResponse response;
        if (initStatus == 1) {
            return ResponseBuilder.buildResponse(EFlowControlResultCode.INIT_ERROR);
        }
        if (initStatus == 2 && initCount < 100 && !(response = FlowControlClient.serverInit()).isSuccessful()) {
            return response;
        }
        return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
    }

    public static WebApiBaseResponse isAlreadyOutOfLimit(String key, String value) {
        if (!FlowControlConfigMap.containsKey(key)) {
            return ResponseBuilder.buildResponse(EFlowControlResultCode.NOT_CONFIG);
        }
        String fcKey = FlowControlKeyBuilder.buildKey(FlowControlClient.getIntervalSeconds(key), key, value);
        if (CacheFactory.isOutOfLimit(fcKey)) {
            return ResponseBuilder.buildResponse(EFlowControlResultCode.OUT_OF_LIMIT);
        }
        return ResponseBuilder.buildResponse(EFlowControlResultCode.SUCCESS);
    }
}

