/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.web.annotation.processor;

import com.google.common.base.Strings;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlClient;
import com.valor.common.flowcontrol.client.web.annotation.WebApiRateLimit;
import common.base.tools.exception.ApiException;
import common.web.tools.http.HttpTools;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.webapi.processor.WebApiCallInterceptor;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Aspect
public class WebApiRateLimitInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiCallInterceptor.class);

    @Pointcut(value="@annotation(com.valor.common.flowcontrol.client.web.annotation.WebApiRateLimit)")
    public void webApiRateLimit() {
    }

    @Around(value="com.valor.common.flowcontrol.client.web.annotation.processor.WebApiRateLimitInterceptor&&@annotation(webApiRateLimit)")
    public Object apiRun(ProceedingJoinPoint pjp, WebApiRateLimit webApiRateLimit) throws ServletException, IOException, ApiException {
        HttpServletRequest request = this.getRequest((JoinPoint)pjp);
        String apiName = webApiRateLimit.name();
        if (Strings.isNullOrEmpty((String)apiName)) {
            apiName = HttpTools.getApiPath((HttpServletRequest)request);
        }
        Object retVal = null;
        try {
            WebApiBaseResponse resp;
            String clientIp = HttpTools.getRemoteHost((HttpServletRequest)request);
            String flowControlKey = FlowControlClient.getFlowControlApi(apiName);
            if (!Strings.isNullOrEmpty((String)flowControlKey) && FlowControlClient.isOutOfLimit(resp = FlowControlClient.counter(flowControlKey, clientIp))) {
                HttpServletResponse response = this.getResponse((JoinPoint)pjp);
                response.setStatus(429);
                return null;
            }
            retVal = pjp.proceed();
        }
        catch (Throwable throwable) {
            logger.error("API:[{}] Exception:[{}]", (Object)apiName, (Object)throwable.toString());
            throw new ApiException(-999, -999, "Internal error");
        }
        return retVal;
    }

    public HttpServletRequest getRequest(JoinPoint jp) {
        return (HttpServletRequest)jp.getArgs()[0];
    }

    public HttpServletResponse getResponse(JoinPoint jp) {
        return (HttpServletResponse)jp.getArgs()[1];
    }
}

