/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.flowcontrol.client.web.filter;

import com.google.common.base.Strings;
import com.valor.common.flowcontrol.client.service.impl.flowcontrol.FlowControlClient;
import common.web.tools.http.HttpTools;
import common.web.tools.http.model.response.WebApiBaseResponse;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class FlowControlFilter
extends OncePerRequestFilter {
    private static Logger logger = LoggerFactory.getLogger(FlowControlFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String clientIp;
        WebApiBaseResponse resp;
        String flowControlKey;
        String apiName = HttpTools.getRequestURI((HttpServletRequest)request);
        if (this.isNeedFlowCtrl(apiName) && !Strings.isNullOrEmpty((String)(flowControlKey = FlowControlClient.getFlowControlApi(apiName))) && FlowControlClient.isOutOfLimit(resp = FlowControlClient.counter(flowControlKey, clientIp = HttpTools.getRemoteHost((HttpServletRequest)request)))) {
            response.setStatus(429);
            logger.error("API:[{}] client ip:[{}] [429:Too Many Requests]", (Object)apiName, (Object)clientIp);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isNeedFlowCtrl(String apiName) {
        if (Strings.isNullOrEmpty((String)apiName)) {
            return false;
        }
        return !"api_ping_v1".equalsIgnoreCase(apiName) && !"api_ping2".equalsIgnoreCase(apiName);
    }
}

