package com.valor.common.lac.client.restcall;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.client.AsyncRestTemplate;

public class RestCallAsync {

    private static Logger logger= LoggerFactory.getLogger(RestCallAsync.class);

    private static AsyncRestTemplate template=getRestClient();

    private static AsyncRestTemplate getRestClient() {
        if (template == null) {
            template = new AsyncRestTemplate(RestCallClient.AsyncHttpFactory());
        }

        return template;
    }

    public static <REQ, RSP> void postAsync(String url, REQ request, Class<RSP> responseType,
                                            ListenableFutureCallback<ResponseEntity<RSP>> callback) {
        try {
            // set headers
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<REQ> entity = new HttpEntity<>(request, headers);

            ListenableFuture<ResponseEntity<RSP>> future = getRestClient().postForEntity(url, entity, responseType);
            future.addCallback(callback);
        } catch (Exception e) {
            logger.error("AsyncRestTemplate:{}", e);
        }
    }

    public static <REQ, RSP> ListenableFuture<ResponseEntity<RSP>> postAsync(String url, REQ request, Class<RSP> responseType) {
        try {
            // set headers
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<REQ> entity = new HttpEntity<>(request, headers);

            ListenableFuture<ResponseEntity<RSP>> future = getRestClient().postForEntity(url, entity, responseType);
            return future;
        } catch (Exception e) {
            logger.error("AsyncRestTemplate:{}", e);
        }
        return null;
    }
}
