package com.valor.common.lac.client.restcall;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RestCallSync {
    private static Logger logger= LoggerFactory.getLogger(RestCallSync.class);

    private static RestTemplate restTemplate=null;

    private static RestTemplate getRestClient(){
         if(restTemplate==null){
             restTemplate=new RestTemplate(RestCallClient.SyncHttpFactory());
         }
         return  restTemplate;
    }

    public static  <REQ,RSP> RSP postSync(String url, REQ request, Class<RSP> returnType){
        try {
            // set headers
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<REQ> entity = new HttpEntity<>(request, headers);

            return getRestClient().postForObject(url, entity, returnType);
        } catch (RestClientException e) {
            logger.error("RestTemplate:{}", e);
            return null;
        }
    }
}
