package com.valor.common.lac.client.service;

import com.google.gson.Gson;
import com.valor.common.lac.client.apimodel.request.ApiLACRequest;
import com.valor.common.lac.client.apimodel.request.ELACTypes;
import com.valor.common.lac.client.apimodel.response.ApiLACResponse;
import com.valor.common.lac.client.restcall.RestCallAsync;
import com.valor.common.lac.client.restcall.RestCallSync;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.concurrent.ListenableFuture;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class LACClient {
    private static Logger logger = LoggerFactory.getLogger(LACClient.class);
    public static final String KEY_HOST = "lac.server.host";
    public static List<String> host;
    private static long count = 0;

    public static void init() {

    }

    /**
     * LAC check(这里预留一个CheckInfo,未来如果增加新的lac_strategy的item,则需要在User模块登录的地方添加map参数)
     *
     * @param appId
     * @param releaseId
     * @param mac
     * @param lang
     * @param accountId
     * @param clientIp
     * @param Region
     * @throws ApiException
     */
    public static void lacSyncCheck(String appId, String releaseId, String mac, String lang, String accountId, String clientIp, String Region) throws ApiException {
        ApiLACRequest lacRequest = new ApiLACRequest();
        lacRequest.setAppId(appId);
        lacRequest.setReleaseId(releaseId);
        lacRequest.setMac(mac);
        lacRequest.setLang(lang);

        //此处接收参数为(值可以为deviceid或者email)
        Map<String, String> valueMap = lacRequest.getCheckInfo();
        valueMap.put(ELACTypes.account.name(), accountId);
        valueMap.put(ELACTypes.ip.name(), clientIp);
        valueMap.put(ELACTypes.region.name(), Region);

        valueMap.put("mac", mac);

        logger.info("[LAC] Request:[{}]", lacRequest);
        try {
            LACClient.synCheck(lacRequest);
        } catch (Exception e) {
            logger.info("[LAC] Deny [{}]. ", lacRequest);
            throw e;
        }
    }

    public static void synCheck(ApiLACRequest apiLACRequest) throws ApiException {
        //全局开关
        if (!ConfigTools3.getBoolean("lac.client.enable", true)) {
            return;
        }

        host = ConfigTools3.getAsList(KEY_HOST, ",");
        if (host.isEmpty()) {
            host.add("localhost:20191");
        }

        int size = host.size();
        count++;
        if (count < 0) {
            count = 0;
        }
        String hostUrl = host.get((int) (count % size));
        String url = "http://" + hostUrl + "/api/lac/check/v1";
        ApiLACResponse apiLACResponse = RestCallSync.postSync(url, apiLACRequest, ApiLACResponse.class);

        //apiLACResponse为空时，允许访问，不要去影响用户使用
        if (apiLACResponse != null && apiLACResponse.getErrCode() != 0) {
            throw new ApiException(apiLACResponse.getRetCode(), apiLACResponse.getErrCode(), apiLACResponse.getErrMsg());
        }
    }

    public static Future<ResponseEntity<ApiLACResponse>> asynCheck(ApiLACRequest apiLACRequest) throws ApiException {

        Gson gson = new Gson();
        host = ConfigTools3.getAsList(KEY_HOST, ",");
        if (host.isEmpty()) {
            host.add("localhost:20191");
        }

        int size = host.size();
        count++;
        if (count < 0) {
            count = 0;
        }
        String hostUrl = host.get((int) (count % size));
        String url = "http://" + hostUrl + "/api/lac/check/v1";
        ListenableFuture<ResponseEntity<ApiLACResponse>> future = RestCallAsync.postAsync(url, apiLACRequest, ApiLACResponse.class);
        return future;
    }
}
