/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.lac.client.service;

import com.google.gson.Gson;
import com.valor.common.lac.client.apimodel.request.ApiLACRequest;
import com.valor.common.lac.client.apimodel.request.ELACTypes;
import com.valor.common.lac.client.apimodel.response.ApiLACResponse;
import com.valor.common.lac.client.restcall.RestCallAsync;
import com.valor.common.lac.client.restcall.RestCallSync;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.concurrent.ListenableFuture;

public class LACClient {
    private static Logger logger = LoggerFactory.getLogger(LACClient.class);
    public static final String KEY_HOST = "lac.server.host";
    public static List<String> host;
    private static long count;

    public static void init() {
    }

    public static void lacSyncCheck(String appId, String releaseId, String mac, String lang, String accountId, String clientIp, String Region) throws ApiException {
        ApiLACRequest lacRequest = new ApiLACRequest();
        lacRequest.setAppId(appId);
        lacRequest.setReleaseId(releaseId);
        lacRequest.setMac(mac);
        lacRequest.setLang(lang);
        Map<String, String> valueMap = lacRequest.getCheckInfo();
        valueMap.put(ELACTypes.account.name(), accountId);
        valueMap.put(ELACTypes.ip.name(), clientIp);
        valueMap.put(ELACTypes.region.name(), Region);
        valueMap.put("mac", mac);
        logger.info("[LAC] Request:[{}]", (Object)lacRequest);
        try {
            LACClient.synCheck(lacRequest);
        }
        catch (Exception e) {
            logger.info("[LAC] Deny [{}]. ", (Object)lacRequest);
            throw e;
        }
    }

    public static void synCheck(ApiLACRequest apiLACRequest) throws ApiException {
        if (!ConfigTools3.getBoolean((String)"lac.client.enable", (boolean)true)) {
            return;
        }
        host = ConfigTools3.getAsList((String)KEY_HOST, (String)",");
        if (host.isEmpty()) {
            host.add("localhost:20191");
        }
        int size = host.size();
        if (++count < 0L) {
            count = 0L;
        }
        String hostUrl = host.get((int)(count % (long)size));
        String url = "http://" + hostUrl + "/api/lac/check/v1";
        ApiLACResponse apiLACResponse = RestCallSync.postSync(url, apiLACRequest, ApiLACResponse.class);
        if (apiLACResponse != null && apiLACResponse.getErrCode() != 0) {
            throw new ApiException(apiLACResponse.getRetCode(), apiLACResponse.getErrCode(), apiLACResponse.getErrMsg());
        }
    }

    public static Future<ResponseEntity<ApiLACResponse>> asynCheck(ApiLACRequest apiLACRequest) throws ApiException {
        Gson gson = new Gson();
        host = ConfigTools3.getAsList((String)KEY_HOST, (String)",");
        if (host.isEmpty()) {
            host.add("localhost:20191");
        }
        int size = host.size();
        if (++count < 0L) {
            count = 0L;
        }
        String hostUrl = host.get((int)(count % (long)size));
        String url = "http://" + hostUrl + "/api/lac/check/v1";
        ListenableFuture<ResponseEntity<ApiLACResponse>> future = RestCallAsync.postAsync(url, apiLACRequest, ApiLACResponse.class);
        return future;
    }

    static {
        count = 0L;
    }
}

