package common.metrics.client;


import com.google.common.base.Strings;

import java.util.Objects;

public class MetricsConfig {
    private String appId;
    private String appKey;
    private int threadPoolSize = 10;
    private int queueSize = 100_000;
    private int postBatchSize = 1000;

    private String httpHosts;
    private int httpConnectTimeout = 1000;
    private int httpReadTimeout = 1000;

    public String getAppId() {
        return appId;
    }

    public MetricsConfig setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppKey() {
        return appKey;
    }

    public MetricsConfig setAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    public String getHttpHosts() {
        return httpHosts;
    }

    public MetricsConfig setHttpHosts(String httpHosts) {
        this.httpHosts = httpHosts;
        return this;
    }

    public int getThreadPoolSize() {
        return threadPoolSize;
    }

    public MetricsConfig setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return this;
    }

    public int getQueueSize() {
        return queueSize;
    }

    public MetricsConfig setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public int getPostBatchSize() {
        return postBatchSize;
    }

    public MetricsConfig setPostBatchSize(int postBatchSize) {
        this.postBatchSize = postBatchSize;
        return this;
    }

    public int getHttpConnectTimeout() {
        return httpConnectTimeout;
    }

    public MetricsConfig setHttpConnectTimeout(int httpConnectTimeout) {
        this.httpConnectTimeout = httpConnectTimeout;
        return this;
    }

    public int getHttpReadTimeout() {
        return httpReadTimeout;
    }

    public MetricsConfig setHttpReadTimeout(int httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
        return this;
    }

    public boolean isConfig() {
        return !Strings.isNullOrEmpty(getAppId()) && !Strings.isNullOrEmpty(getHttpHosts());
    }

    public final static class Builder {
        private MetricsConfig instance = null;
        private static Builder builderInstance = null;

        public static Builder newBuilder() {
            if (Objects.nonNull(builderInstance)) {
                builderInstance = new Builder();
            }
            return builderInstance;
        }

        public MetricsConfig build() {
            if (Objects.isNull(instance)) {
                instance = new MetricsConfig();
            }
            return instance;
        }
    }
}
